/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryTransformNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SourceNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.schema.VectorMeasurementSchema;

public class LastQueryNode
extends MultiChildProcessNode {
    private Ordering timeseriesOrdering;
    private boolean containsLastTransformNode;
    private Map<IMeasurementSchema, Integer> measurementSchema2IdxMap;
    private final List<IMeasurementSchema> globalMeasurementSchemaList;

    public LastQueryNode(PlanNodeId id, @Nullable Ordering timeseriesOrdering, boolean containsLastTransformNode) {
        super(id);
        this.timeseriesOrdering = timeseriesOrdering;
        this.containsLastTransformNode = containsLastTransformNode;
        this.measurementSchema2IdxMap = new HashMap<IMeasurementSchema, Integer>();
        this.globalMeasurementSchemaList = new ArrayList<IMeasurementSchema>();
    }

    public LastQueryNode(PlanNodeId id, @Nullable Ordering timeseriesOrdering, boolean containsLastTransformNode, List<IMeasurementSchema> globalMeasurementSchemaList) {
        super(id);
        this.timeseriesOrdering = timeseriesOrdering;
        this.containsLastTransformNode = containsLastTransformNode;
        this.globalMeasurementSchemaList = globalMeasurementSchemaList;
    }

    public long addDeviceLastQueryScanNode(PlanNodeId id, PartialPath devicePath, boolean aligned, List<IMeasurementSchema> measurementSchemas, String outputViewPath, TSDataType outputViewPathType) {
        ArrayList<Integer> idxList = new ArrayList<Integer>(measurementSchemas.size());
        for (IMeasurementSchema measurementSchema : measurementSchemas) {
            int idx = this.measurementSchema2IdxMap.computeIfAbsent(measurementSchema, key -> {
                this.globalMeasurementSchemaList.add((IMeasurementSchema)key);
                return this.globalMeasurementSchemaList.size() - 1;
            });
            idxList.add(idx);
        }
        LastQueryScanNode scanNode = new LastQueryScanNode(id, devicePath, aligned, idxList, outputViewPath, outputViewPathType, this.globalMeasurementSchemaList);
        this.children.add(scanNode);
        return scanNode.ramBytesUsed();
    }

    public void sort() {
        if (this.timeseriesOrdering == null) {
            return;
        }
        this.children.sort(Comparator.comparing(child -> {
            String sortKey = "";
            if (child instanceof LastQueryScanNode) {
                sortKey = ((LastQueryScanNode)child).getOutputSymbolForSort();
            } else if (child instanceof LastQueryTransformNode) {
                sortKey = ((LastQueryTransformNode)child).getOutputSymbolForSort();
            }
            return sortKey;
        }));
        if (this.timeseriesOrdering.equals((Object)Ordering.DESC)) {
            Collections.reverse(this.children);
        }
    }

    public void clearMeasurementSchema2IdxMap() {
        this.measurementSchema2IdxMap = null;
    }

    public long getMemorySizeOfSharedStructures() {
        return RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.shallowSizeOf(this.globalMeasurementSchemaList) + RamUsageEstimator.sizeOfObjectArray((int)this.globalMeasurementSchemaList.size())));
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.LAST_QUERY;
    }

    @Override
    public PlanNode clone() {
        return new LastQueryNode(this.getPlanNodeId(), this.timeseriesOrdering, this.containsLastTransformNode, this.globalMeasurementSchemaList);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LastQueryScanNode.LAST_QUERY_HEADER_COLUMNS;
    }

    public String toString() {
        return String.format("LastQueryNode-%s", this.getPlanNodeId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LastQueryNode that = (LastQueryNode)o;
        if (this.timeseriesOrdering == null) {
            return that.timeseriesOrdering == null;
        }
        return this.timeseriesOrdering.equals((Object)that.timeseriesOrdering);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.timeseriesOrdering});
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLastQuery(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LAST_QUERY.serialize(byteBuffer);
        if (this.timeseriesOrdering == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)this.timeseriesOrdering.ordinal(), (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.globalMeasurementSchemaList.size(), (ByteBuffer)byteBuffer);
        for (IMeasurementSchema measurementSchema : this.globalMeasurementSchemaList) {
            if (measurementSchema instanceof MeasurementSchema) {
                ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
            } else if (measurementSchema instanceof VectorMeasurementSchema) {
                ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            }
            measurementSchema.serializeTo(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LAST_QUERY.serialize(stream);
        if (this.timeseriesOrdering == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.timeseriesOrdering.ordinal(), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.globalMeasurementSchemaList.size(), (OutputStream)stream);
        for (IMeasurementSchema measurementSchema : this.globalMeasurementSchemaList) {
            if (measurementSchema instanceof MeasurementSchema) {
                ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
            } else if (measurementSchema instanceof VectorMeasurementSchema) {
                ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            }
            measurementSchema.serializeTo((OutputStream)stream);
        }
    }

    public static LastQueryNode deserialize(ByteBuffer byteBuffer) {
        byte needOrderByTimeseries = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Ordering timeseriesOrdering = null;
        if (needOrderByTimeseries == 1) {
            timeseriesOrdering = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        }
        int measurementSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<IMeasurementSchema> measurementSchemas = new ArrayList<IMeasurementSchema>(measurementSize);
        for (int i = 0; i < measurementSize; ++i) {
            byte type = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
            if (type == 0) {
                measurementSchemas.add((IMeasurementSchema)MeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer));
                continue;
            }
            if (type != 1) continue;
            measurementSchemas.add((IMeasurementSchema)VectorMeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LastQueryNode(planNodeId, timeseriesOrdering, false, measurementSchemas);
    }

    @Override
    public void setChildren(List<PlanNode> children) {
        this.children = children;
    }

    @Override
    public void addChild(PlanNode child) {
        if (child instanceof LastQueryScanNode) {
            LastQueryScanNode childNode = (LastQueryScanNode)child;
            childNode.setGlobalMeasurementSchemaList(this.globalMeasurementSchemaList);
        }
        super.addChild(child);
    }

    public Ordering getTimeseriesOrdering() {
        return this.timeseriesOrdering;
    }

    public void setTimeseriesOrdering(Ordering timeseriesOrdering) {
        this.timeseriesOrdering = timeseriesOrdering;
    }

    public boolean isContainsLastTransformNode() {
        return this.containsLastTransformNode;
    }

    public void setContainsLastTransformNode() {
        this.containsLastTransformNode = true;
    }

    public boolean needOrderByTimeseries() {
        return this.timeseriesOrdering != null;
    }

    public TRegionReplicaSet getRegionReplicaSetByFirstChild() {
        SourceNode planNode = (SourceNode)this.children.get(0);
        return planNode.getRegionReplicaSet();
    }
}

