/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra;

import jakarta.inject.Inject;
import java.time.Clock;
import java.util.EnumSet;
import org.apache.james.events.EventBus;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.cassandra.CassandraMailboxSessionMapperFactory;
import org.apache.james.mailbox.cassandra.CassandraMessageManager;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import reactor.core.publisher.Mono;

public class CassandraMailboxManager
extends StoreMailboxManager {
    public static final EnumSet<MailboxManager.MailboxCapabilities> MAILBOX_CAPABILITIES = EnumSet.of(MailboxManager.MailboxCapabilities.Move, new MailboxManager.MailboxCapabilities[]{MailboxManager.MailboxCapabilities.UserFlag, MailboxManager.MailboxCapabilities.Namespace, MailboxManager.MailboxCapabilities.Annotation, MailboxManager.MailboxCapabilities.ACL, MailboxManager.MailboxCapabilities.Quota});
    public static final EnumSet<MailboxManager.MessageCapabilities> MESSAGE_CAPABILITIES = EnumSet.of(MailboxManager.MessageCapabilities.UniqueID);
    private final MailboxPathLocker locker;
    private final CassandraMailboxSessionMapperFactory mapperFactory;

    @Inject
    public CassandraMailboxManager(CassandraMailboxSessionMapperFactory mapperFactory, SessionProvider sessionProvider, MailboxPathLocker locker, MessageParser messageParser, MessageId.Factory messageIdFactory, EventBus eventBus, StoreMailboxAnnotationManager annotationManager, StoreRightManager storeRightManager, QuotaComponents quotaComponents, MessageSearchIndex index, MailboxManagerConfiguration configuration, PreDeletionHooks preDeletionHooks, ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm, Clock clock) {
        super((MailboxSessionMapperFactory)mapperFactory, sessionProvider, locker, messageParser, messageIdFactory, (MailboxAnnotationManager)annotationManager, eventBus, storeRightManager, quotaComponents, index, configuration, preDeletionHooks, threadIdGuessingAlgorithm, clock);
        this.locker = locker;
        this.mapperFactory = mapperFactory;
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return MAILBOX_CAPABILITIES;
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return MESSAGE_CAPABILITIES;
    }

    protected StoreMessageManager createMessageManager(Mailbox mailboxRow, MailboxSession session) {
        return new CassandraMessageManager(this.mapperFactory, this.getMessageSearchIndex(), this.getEventBus(), this.locker, mailboxRow, this.getQuotaComponents().getQuotaManager(), this.getQuotaComponents().getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.configuration.getBatchSizes(), this.getStoreRightManager(), this.getPreDeletionHooks(), this.getThreadIdGuessingAlgorithm(), this.getClock());
    }

    public <T> Mono<T> manageProcessing(Mono<T> toBeWrapped, MailboxSession mailboxSession) {
        return toBeWrapped;
    }
}

