/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPDN {
    private LDAPDN() {
    }

    @NotNull
    public static String normalize(@NotNull String dn) {
        try {
            return DN.normalize(dn);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return StaticUtils.toLowerCase(dn.trim());
        }
    }

    @NotNull
    public static String[] explodeDN(@NotNull String dn, boolean noTypes) {
        try {
            RDN[] rdns = new DN(dn).getRDNs();
            String[] rdnStrings = new String[rdns.length];
            for (int i = 0; i < rdns.length; ++i) {
                if (noTypes) {
                    StringBuilder buffer = new StringBuilder();
                    for (String s : rdns[i].getAttributeValues()) {
                        if (buffer.length() > 0) {
                            buffer.append('+');
                        }
                        buffer.append(s);
                    }
                    rdnStrings[i] = buffer.toString();
                    continue;
                }
                rdnStrings[i] = rdns[i].toString();
            }
            return rdnStrings;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new String[]{dn};
        }
    }

    @NotNull
    public static String[] explodeRDN(@NotNull String rdn, boolean noTypes) {
        try {
            RDN rdnObject = new RDN(rdn);
            String[] values = rdnObject.getAttributeValues();
            if (noTypes) {
                return values;
            }
            String[] names = rdnObject.getAttributeNames();
            String[] returnStrs = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                returnStrs[i] = names[i] + '=' + values[i];
            }
            return returnStrs;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new String[]{rdn};
        }
    }

    public static boolean equals(@NotNull String dn1, @NotNull String dn2) {
        try {
            return DN.equals(dn1, dn2);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }
}

