/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.NameValuePair;
import org.apache.http.util.CharArrayBuffer;
import org.apache.juneau.commons.collections.ControlledArrayList;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.PredicateUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.BasicHeaderIterator;
import org.apache.juneau.http.header.HeaderBeanMeta;
import org.apache.juneau.svl.VarResolver;

public class HeaderList
extends ControlledArrayList<Header> {
    private static final long serialVersionUID = 1L;
    private VarResolver varResolver;
    boolean caseSensitive;

    public static HeaderList create() {
        return new HeaderList();
    }

    public static HeaderList of(Header ... headers) {
        return new HeaderList().append(headers);
    }

    public static HeaderList of(List<Header> headers) {
        return new HeaderList().append(headers);
    }

    public static HeaderList ofPairs(String ... pairs) {
        HeaderList x = new HeaderList();
        if (pairs == null) {
            pairs = new String[]{};
        }
        AssertionUtils.assertArg(pairs.length % 2 == 0, "Odd number of parameters passed into HeaderList.ofPairs()", new Object[0]);
        for (int i = 0; i < pairs.length; i += 2) {
            x.add(BasicHeader.of(pairs[i], pairs[i + 1]));
        }
        return x;
    }

    public HeaderList() {
        super(false);
    }

    protected HeaderList(HeaderList copyFrom) {
        super(false, copyFrom);
        this.caseSensitive = copyFrom.caseSensitive;
    }

    public HeaderList append(Header value) {
        if (Utils.nn(value)) {
            this.add(value);
        }
        return this;
    }

    public HeaderList append(Header ... values) {
        if (Utils.nn(values)) {
            for (Header value : values) {
                if (!Utils.nn(value)) continue;
                this.append(value);
            }
        }
        return this;
    }

    public HeaderList append(List<Header> values) {
        if (Utils.nn(values)) {
            values.forEach(this::append);
        }
        return this;
    }

    public HeaderList append(String name, Object value) {
        return this.append(this.createPart(name, value));
    }

    public HeaderList append(String name, Supplier<?> value) {
        return this.append(this.createPart(name, value));
    }

    public HeaderList caseSensitive(boolean value) {
        this.assertModifiable();
        this.caseSensitive = value;
        return this;
    }

    public boolean contains(String name) {
        return this.stream().anyMatch(x -> this.eq(x.getName(), name));
    }

    public HeaderList copy() {
        return new HeaderList(this);
    }

    public HeaderList forEach(Predicate<Header> filter, Consumer<Header> action) {
        this.forEach((? super E x) -> PredicateUtils.consumeIf(filter, action, x));
        return this;
    }

    public HeaderList forEach(String name, Consumer<Header> action) {
        return this.forEach((Header x) -> this.eq(name, x.getName()), action);
    }

    public HeaderList forEachValue(Predicate<Header> filter, Consumer<String> action) {
        return this.forEach(filter, (Header x) -> action.accept(x.getValue()));
    }

    public HeaderList forEachValue(String name, Consumer<String> action) {
        return this.forEach(name, (Header x) -> action.accept(x.getValue()));
    }

    public <T> Optional<T> get(Class<T> type) {
        AssertionUtils.assertArgNotNull("type", type);
        String name = HeaderBeanMeta.of(type).getSchema().getName();
        AssertionUtils.assertArg(Utils.nn(name), "Header name could not be found on bean type ''{0}''", Utils.cn(type));
        return this.get(name, type);
    }

    public Optional<Header> get(String name) {
        Header first = null;
        List<Header> rest = null;
        for (Header x : this) {
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list(new Header[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return Utils.opte();
        }
        if (rest == null) {
            return Utils.opt(first);
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (Header element : rest) {
            sb.append(", ");
            sb.append(element.getValue());
        }
        return Utils.opt(new BasicHeader(name, sb.toString()));
    }

    public <T> Optional<T> get(String name, Class<T> type) {
        Header first = null;
        List<Header> rest = null;
        for (Header x : this) {
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list(new Header[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return Utils.opte();
        }
        if (rest == null) {
            return Utils.opt(HeaderBeanMeta.of(type).construct(name, first.getValue()));
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (Header element : rest) {
            sb.append(", ");
            sb.append(element.getValue());
        }
        return Utils.opt(HeaderBeanMeta.of(type).construct(name, sb.toString()));
    }

    public Header[] getAll() {
        return (Header[])this.stream().toArray(Header[]::new);
    }

    public Header[] getAll(String name) {
        return (Header[])this.stream().filter(x -> this.eq(x.getName(), name)).toArray(Header[]::new);
    }

    public Optional<Header> getFirst(String name) {
        for (int i = 0; i < this.size(); ++i) {
            Header x = (Header)this.get(i);
            if (!this.eq(x.getName(), name)) continue;
            return Utils.opt(x);
        }
        return Utils.opte();
    }

    public Optional<Header> getLast(String name) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Header x = (Header)this.get(i);
            if (!this.eq(x.getName(), name)) continue;
            return Utils.opt(x);
        }
        return Utils.opte();
    }

    public String[] getValues(String name) {
        return (String[])this.stream().filter(x -> this.eq(x.getName(), name)).map(NameValuePair::getValue).toArray(String[]::new);
    }

    public HeaderIterator headerIterator() {
        return new BasicHeaderIterator(this.toArray(new Header[0]), null, this.caseSensitive);
    }

    public HeaderIterator headerIterator(String name) {
        return new BasicHeaderIterator(this.getAll(name), name, this.caseSensitive);
    }

    public HeaderList prepend(Header value) {
        if (Utils.nn(value)) {
            this.add(0, value);
        }
        return this;
    }

    public HeaderList prepend(Header ... values) {
        if (Utils.nn(values)) {
            this.prepend(CollectionUtils.l(values));
        }
        return this;
    }

    public HeaderList prepend(List<Header> values) {
        if (Utils.nn(values)) {
            this.addAll(0, values);
        }
        return this;
    }

    public HeaderList prepend(String name, Object value) {
        return this.prepend(this.createPart(name, value));
    }

    public HeaderList prepend(String name, Supplier<?> value) {
        return this.prepend(this.createPart(name, value));
    }

    public HeaderList remove(Header value) {
        if (Utils.nn(value)) {
            this.removeIf(x -> this.eq(x.getName(), value.getName()) && this.eq(x.getValue(), value.getValue()));
        }
        return this;
    }

    public HeaderList remove(Header ... values) {
        for (Header value : values) {
            this.remove(value);
        }
        return this;
    }

    public HeaderList remove(List<Header> values) {
        if (Utils.nn(values)) {
            values.forEach(this::remove);
        }
        return this;
    }

    public HeaderList remove(String name) {
        this.removeIf(x -> this.eq(x.getName(), name));
        return this;
    }

    public HeaderList remove(String ... names) {
        if (Utils.nn(names)) {
            for (String name : names) {
                this.remove(name);
            }
        }
        return this;
    }

    public HeaderList removeAll() {
        this.clear();
        return this;
    }

    public HeaderList resolving() {
        return this.resolving(VarResolver.DEFAULT);
    }

    public HeaderList resolving(VarResolver varResolver) {
        this.assertModifiable();
        this.varResolver = varResolver;
        return this;
    }

    public HeaderList set(Header value) {
        if (Utils.nn(value)) {
            boolean replaced = false;
            int j = this.size();
            for (int i = 0; i < j; ++i) {
                Header x = (Header)this.get(i);
                if (!this.eq(x.getName(), value.getName())) continue;
                if (replaced) {
                    this.remove(i);
                    --j;
                    continue;
                }
                this.set(i, value);
                replaced = true;
            }
            if (!replaced) {
                this.add(value);
            }
        }
        return this;
    }

    public HeaderList set(Header ... values) {
        if (Utils.nn(values)) {
            this.set(CollectionUtils.l(values));
        }
        return this;
    }

    public HeaderList set(List<Header> values) {
        if (Utils.nn(values)) {
            for (Header h : values) {
                if (!Utils.nn(h)) continue;
                int j2 = this.size();
                for (int i2 = 0; i2 < j2; ++i2) {
                    Header x = (Header)this.get(i2);
                    if (!this.eq(x.getName(), h.getName())) continue;
                    this.remove(i2);
                    --j2;
                }
            }
            for (Header x : values) {
                if (!Utils.nn(x)) continue;
                this.add(x);
            }
        }
        return this;
    }

    public HeaderList set(String name, Object value) {
        return this.set(this.createPart(name, value));
    }

    public HeaderList set(String name, Supplier<?> value) {
        return this.set(this.createPart(name, value));
    }

    public HeaderList setDefault(Header ... headers) {
        if (Utils.nn(headers)) {
            this.setDefault(CollectionUtils.l(headers));
        }
        return this;
    }

    public HeaderList setDefault(List<Header> headers) {
        if (Utils.nn(headers)) {
            headers.stream().filter(x -> Utils.nn(x) && !this.contains(x.getName())).forEach(this::set);
        }
        return this;
    }

    public HeaderList setDefault(String name, Object value) {
        return this.setDefault(this.createPart(name, value));
    }

    public HeaderList setDefault(String name, Supplier<?> value) {
        return this.setDefault(this.createPart(name, value));
    }

    public HeaderList setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }

    public Stream<Header> stream(String name) {
        return this.stream().filter(x -> this.eq(name, x.getName()));
    }

    @Override
    public String toString() {
        return "[" + StringUtils.join(this, ", ") + "]";
    }

    private Header createPart(String name, Object value) {
        boolean isResolving = Utils.nn(this.varResolver);
        if (value instanceof Supplier) {
            Supplier value2 = (Supplier)value;
            return isResolving ? new BasicHeader(name, this.resolver(value2)) : new BasicHeader(name, (Object)value2);
        }
        return isResolving ? new BasicHeader(name, this.resolver(value)) : new BasicHeader(name, value);
    }

    private boolean eq(String s1, String s2) {
        return Utils.eq(!this.caseSensitive, s1, s2);
    }

    private Supplier<Object> resolver(Object input) {
        return () -> this.varResolver.resolve(Utils.s(HeaderList.unwrap(input)));
    }

    private static Object unwrap(Object o) {
        while (o instanceof Supplier) {
            Supplier s = (Supplier)o;
            o = s.get();
        }
        return o;
    }

    public static final class Void
    extends HeaderList {
        private static final long serialVersionUID = 1L;
    }
}

