/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.annotation.Attr;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;

public class AttributeArg
implements RestOpArg {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final String name;
    private final Class<?> type;

    public static AttributeArg create(ParameterInfo paramInfo) {
        if (AP.has(Attr.class, paramInfo, new AnnotationTraversal[0])) {
            return new AttributeArg(paramInfo);
        }
        return null;
    }

    protected AttributeArg(ParameterInfo paramInfo) {
        this.name = AttributeArg.getName(paramInfo);
        this.type = paramInfo.getParameterType().inner();
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        return opSession.getRequest().getAttribute(this.name).as(this.type).orElse(null);
    }

    private static String getName(ParameterInfo paramInfo) {
        return AP.find(Attr.class, paramInfo, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).filter(x -> StringUtils.isAnyNotBlank(x.value(), x.name())).findFirst().map(x -> StringUtils.firstNonBlank(x.name(), x.value())).orElseThrow(() -> new ArgException(paramInfo, "@Attr used without name or value", new Object[0]));
    }
}

