/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.settings;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.juneau.commons.function.Snippet;
import org.apache.juneau.commons.settings.SettingStore;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class FunctionalStore
implements SettingStore {
    private final Function<String, String> reader;
    private final BiConsumer<String, String> writer;
    private final Consumer<String> unsetter;
    private final Snippet clearer;

    public FunctionalStore(Function<String, String> reader, BiConsumer<String, String> writer, Consumer<String> unsetter, Snippet clearer) {
        AssertionUtils.assertArgNotNull("reader", reader);
        AssertionUtils.assertArgNotNull("writer", writer);
        AssertionUtils.assertArgNotNull("unsetter", unsetter);
        AssertionUtils.assertArgNotNull("clearer", clearer);
        this.reader = reader;
        this.writer = writer;
        this.unsetter = unsetter;
        this.clearer = clearer;
    }

    @Override
    public Optional<String> get(String name) {
        String v = this.reader.apply(name);
        return v == null ? null : Utils.opt(v);
    }

    @Override
    public void set(String name, String value) {
        this.writer.accept(name, value);
    }

    @Override
    public void unset(String name) {
        this.unsetter.accept(name);
    }

    @Override
    public void clear() {
        Utils.safe(() -> this.clearer.run());
    }

    public static FunctionalStore of(Function<String, String> reader, BiConsumer<String, String> writer, Consumer<String> unsetter, Snippet clearer) {
        return new FunctionalStore(reader, writer, unsetter, clearer);
    }
}

