/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swaps;

import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.DateUtils;
import org.apache.juneau.swap.StringSwap;
import org.apache.juneau.swaps.DefaultingTemporalAccessor;

public class TemporalSwap
extends StringSwap<Temporal> {
    private static final ZoneId Z = ZoneId.of("Z");
    private static final Map<Class<? extends Temporal>, Method> FROM_METHODS = new ConcurrentHashMap<Class<? extends Temporal>, Method>();
    private final DateTimeFormatter formatter;
    private final boolean zoneOptional;

    private static Method findParseMethod(Class<? extends Temporal> c) throws ExecutableException {
        Method m = FROM_METHODS.get(c);
        if (m == null) {
            m = ReflectionUtils.info(c).getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && x.hasName("from") && x.hasReturnType(c) && x.hasParameterTypes(new Class[]{TemporalAccessor.class})).map(MethodInfo::inner).orElseThrow(() -> new ExecutableException("Parse method not found on temporal class ''{0}''", new Object[]{c.getSimpleName()}));
            FROM_METHODS.put(c, m);
        }
        return m;
    }

    public TemporalSwap(String pattern, boolean zoneOptional) {
        super(Temporal.class);
        this.formatter = DateUtils.getDateTimeFormatter((String)pattern);
        this.zoneOptional = zoneOptional;
    }

    @Override
    public String swap(BeanSession session, Temporal o) throws Exception {
        if (o == null) {
            return null;
        }
        o = this.convertToSerializable(session, o);
        return this.formatter.format(o);
    }

    @Override
    public Temporal unswap(BeanSession session, String f, ClassMeta<?> hint) throws Exception {
        if (f == null) {
            return null;
        }
        if (hint == null) {
            hint = session.getClassMeta(Instant.class);
        }
        Class tc = hint.inner();
        ZoneId offset = session.getTimeZoneId();
        if (tc == Instant.class) {
            offset = Z;
        }
        Method parseMethod = TemporalSwap.findParseMethod(tc);
        TemporalAccessor ta = TemporalSwap.defaulting(this.formatter.parse(f), offset);
        return (Temporal)parseMethod.invoke(null, ta);
    }

    private static final TemporalAccessor defaulting(TemporalAccessor t, ZoneId zoneId) {
        return new DefaultingTemporalAccessor(t, zoneId);
    }

    protected Temporal convertToSerializable(BeanSession session, Temporal t) {
        ZoneId zoneId = session.getTimeZoneId();
        Class<?> tc = t.getClass();
        if (tc == Instant.class) {
            return ZonedDateTime.from(TemporalSwap.defaulting(t, Z));
        }
        if (tc == ZonedDateTime.class || tc == OffsetDateTime.class) {
            return t;
        }
        if (this.zoneOptional()) {
            if (tc == LocalDateTime.class) {
                return t;
            }
            if (tc == OffsetTime.class) {
                return ZonedDateTime.from(TemporalSwap.defaulting(t, zoneId));
            }
            return LocalDateTime.from(TemporalSwap.defaulting(t, zoneId));
        }
        return ZonedDateTime.from(TemporalSwap.defaulting(t, zoneId));
    }

    protected boolean zoneOptional() {
        return this.zoneOptional;
    }

    public static class Rfc1123DateTime
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new Rfc1123DateTime();

        public Rfc1123DateTime() {
            super("RFC_1123_DATE_TIME", false);
        }
    }

    public static class IsoZonedDateTime
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoZonedDateTime();

        public IsoZonedDateTime() {
            super("ISO_ZONED_DATE_TIME", false);
        }
    }

    public static class IsoYearMonth
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoYearMonth();

        public IsoYearMonth() {
            super("uuuu-MM", true);
        }
    }

    public static class IsoYear
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoYear();

        public IsoYear() {
            super("uuuu", true);
        }
    }

    public static class IsoWeekDate
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoWeekDate();

        public IsoWeekDate() {
            super("ISO_WEEK_DATE", true);
        }
    }

    public static class IsoTime
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoTime();

        public IsoTime() {
            super("ISO_TIME", true);
        }
    }

    public static class IsoOrdinalDate
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoOrdinalDate();

        public IsoOrdinalDate() {
            super("ISO_ORDINAL_DATE", true);
        }
    }

    public static class IsoOffsetTime
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoOffsetTime();

        public IsoOffsetTime() {
            super("ISO_OFFSET_TIME", false);
        }
    }

    public static class IsoOffsetDateTime
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoOffsetDateTime();

        public IsoOffsetDateTime() {
            super("ISO_OFFSET_DATE_TIME", false);
        }
    }

    public static class IsoOffsetDate
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoOffsetDate();

        public IsoOffsetDate() {
            super("ISO_OFFSET_DATE", false);
        }
    }

    public static class IsoLocalTime
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoLocalTime();

        public IsoLocalTime() {
            super("ISO_LOCAL_TIME", true);
        }
    }

    public static class IsoLocalDateTime
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoLocalDateTime();

        public IsoLocalDateTime() {
            super("ISO_LOCAL_DATE_TIME", true);
        }
    }

    public static class IsoLocalDate
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoLocalDate();

        public IsoLocalDate() {
            super("ISO_LOCAL_DATE", false);
        }
    }

    public static class IsoInstant
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoInstant();

        public IsoInstant() {
            super("ISO_INSTANT", false);
        }
    }

    public static class IsoDateTime
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoDateTime();

        public IsoDateTime() {
            super("ISO_DATE_TIME", true);
        }
    }

    public static class IsoDate
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new IsoDate();

        public IsoDate() {
            super("ISO_DATE", true);
        }
    }

    public static class BasicIsoDate
    extends TemporalSwap {
        public static final TemporalSwap DEFAULT = new BasicIsoDate();

        public BasicIsoDate() {
            super("BASIC_ISO_DATE", true);
        }
    }
}

