/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.juneau.commons.reflect.AccessibleInfo;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.AnnotatableType;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ClassArrayFormat;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassNameFormat;
import org.apache.juneau.commons.reflect.ElementFlag;
import org.apache.juneau.commons.reflect.PackageInfo;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AnnotationUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class FieldInfo
extends AccessibleInfo
implements Comparable<FieldInfo>,
Annotatable {
    private final Field inner;
    private final ClassInfo declaringClass;
    private final Supplier<ClassInfo> type;
    private final Supplier<List<AnnotationInfo<Annotation>>> annotations;
    private final Supplier<String> fullName;

    public static FieldInfo of(ClassInfo declaringClass, Field inner) {
        AssertionUtils.assertArgNotNull("declaringClass", declaringClass);
        return declaringClass.getField(inner);
    }

    public static FieldInfo of(Field inner) {
        AssertionUtils.assertArgNotNull("inner", inner);
        return ClassInfo.of(inner.getDeclaringClass()).getField(inner);
    }

    protected FieldInfo(ClassInfo declaringClass, Field inner) {
        super(inner, inner.getModifiers());
        AssertionUtils.assertArgNotNull("inner", inner);
        this.declaringClass = declaringClass;
        this.inner = inner;
        this.type = Utils.mem(() -> ClassInfo.of(inner.getType(), inner.getGenericType()));
        this.annotations = Utils.mem(() -> CollectionUtils.stream(inner.getAnnotations()).flatMap(a -> AnnotationUtils.streamRepeated(a)).map(a -> this.ai(this, a)).toList());
        this.fullName = Utils.mem(this::findFullName);
    }

    public FieldInfo accessible() {
        this.setAccessible();
        return this;
    }

    @Override
    public int compareTo(FieldInfo o) {
        return Utils.cmp(this.getName(), o.getName());
    }

    public <T> T get(Object o) throws BeanRuntimeException {
        return (T)Utils.safe(() -> {
            this.inner.setAccessible(true);
            return this.inner.get(o);
        }, e -> ThrowableUtils.bex(e));
    }

    @Override
    public AnnotatableType getAnnotatableType() {
        return AnnotatableType.FIELD_TYPE;
    }

    public AnnotatedType getAnnotatedType() {
        return this.inner.getAnnotatedType();
    }

    public List<AnnotationInfo<Annotation>> getAnnotations() {
        return this.annotations.get();
    }

    public <A extends Annotation> Stream<AnnotationInfo<A>> getAnnotations(Class<A> type) {
        return this.annotations.get().stream().filter(x -> type.isInstance(x.inner())).map(x -> x);
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public ClassInfo getFieldType() {
        return this.type.get();
    }

    public String getFullName() {
        return this.fullName.get();
    }

    @Override
    public String getLabel() {
        return this.getDeclaringClass().getNameSimple() + "." + this.getName();
    }

    public String getName() {
        return this.inner.getName();
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return this.getAnnotations(type).findAny().isPresent();
    }

    public boolean hasName(String name) {
        return this.inner.getName().equals(name);
    }

    public Field inner() {
        return this.inner;
    }

    public boolean equals(Object obj) {
        FieldInfo other;
        return obj instanceof FieldInfo && Utils.eq(this, other = (FieldInfo)obj, (x, y) -> Utils.eq(x.inner, y.inner));
    }

    public int hashCode() {
        return this.inner.hashCode();
    }

    @Override
    public boolean is(ElementFlag flag) {
        return switch (flag) {
            case ElementFlag.DEPRECATED -> this.isDeprecated();
            case ElementFlag.NOT_DEPRECATED -> this.isNotDeprecated();
            case ElementFlag.ENUM_CONSTANT -> this.isEnumConstant();
            case ElementFlag.NOT_ENUM_CONSTANT -> {
                if (!this.isEnumConstant()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.SYNTHETIC -> this.isSynthetic();
            case ElementFlag.NOT_SYNTHETIC -> {
                if (!this.isSynthetic()) {
                    yield true;
                }
                yield false;
            }
            default -> super.is(flag);
        };
    }

    public boolean isDeprecated() {
        return this.inner.isAnnotationPresent(Deprecated.class);
    }

    public boolean isEnumConstant() {
        return this.inner.isEnumConstant();
    }

    public boolean isNotDeprecated() {
        return !this.inner.isAnnotationPresent(Deprecated.class);
    }

    public boolean isSynthetic() {
        return this.inner.isSynthetic();
    }

    public boolean isVisible(Visibility v) {
        return v.isVisible(this.inner);
    }

    public void set(Object o, Object value) throws BeanRuntimeException {
        Utils.safe(() -> {
            this.inner.setAccessible(true);
            this.inner.set(o, value);
        }, e -> ThrowableUtils.bex(e));
    }

    public void setIfNull(Object o, Object value) {
        Object v = this.get(o);
        if (v == null) {
            this.set(o, value);
        }
    }

    public String toGenericString() {
        return this.inner.toGenericString();
    }

    public String toString() {
        return Utils.cn(this.inner.getDeclaringClass()) + "." + this.inner.getName();
    }

    private String findFullName() {
        StringBuilder sb = new StringBuilder(128);
        ClassInfo dc = this.declaringClass;
        PackageInfo pi = dc.getPackage();
        if (Utils.nn(pi)) {
            sb.append(pi.getName()).append('.');
        }
        dc.appendNameFormatted(sb, ClassNameFormat.SHORT, true, '$', ClassArrayFormat.BRACKETS);
        sb.append('.').append(this.getName());
        return sb.toString();
    }
}

