/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto;

import org.apache.shiro.crypto.AbstractSymmetricCipherService;
import org.apache.shiro.crypto.OperationMode;
import org.apache.shiro.crypto.PaddingScheme;
import org.apache.shiro.util.StringUtils;

public class DefaultBlockCipherService
extends AbstractSymmetricCipherService {
    private static final int DEFAULT_BLOCK_SIZE = 0;
    private static final String TRANSFORMATION_STRING_DELIMITER = "/";
    private static final int DEFAULT_STREAMING_BLOCK_SIZE = 8;
    private String modeName = OperationMode.CBC.name();
    private int blockSize = 0;
    private String paddingSchemeName = PaddingScheme.PKCS5.getTransformationName();
    private String streamingModeName = OperationMode.CBC.name();
    private int streamingBlockSize = 8;
    private String streamingPaddingSchemeName = PaddingScheme.PKCS5.getTransformationName();
    private String transformationString;
    private String streamingTransformationString;

    public DefaultBlockCipherService(String algorithmName) {
        super(algorithmName);
    }

    public String getModeName() {
        return this.modeName;
    }

    public void setModeName(String modeName) {
        this.modeName = modeName;
        this.transformationString = null;
    }

    public void setMode(OperationMode mode) {
        this.setModeName(mode.name());
    }

    public String getPaddingSchemeName() {
        return this.paddingSchemeName;
    }

    public void setPaddingSchemeName(String paddingSchemeName) {
        this.paddingSchemeName = paddingSchemeName;
        this.transformationString = null;
    }

    public void setPaddingScheme(PaddingScheme paddingScheme) {
        this.setPaddingSchemeName(paddingScheme.getTransformationName());
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = Math.max(0, blockSize);
        this.transformationString = null;
    }

    public String getStreamingModeName() {
        return this.streamingModeName;
    }

    private boolean isModeStreamingCompatible(String modeName) {
        return modeName != null && !modeName.equalsIgnoreCase(OperationMode.ECB.name()) && !modeName.equalsIgnoreCase(OperationMode.NONE.name());
    }

    public void setStreamingModeName(String streamingModeName) {
        if (!this.isModeStreamingCompatible(streamingModeName)) {
            String msg = "mode [" + streamingModeName + "] is not a valid operation mode for block cipher streaming.";
            throw new IllegalArgumentException(msg);
        }
        this.streamingModeName = streamingModeName;
        this.streamingTransformationString = null;
    }

    public void setStreamingMode(OperationMode mode) {
        this.setStreamingModeName(mode.name());
    }

    public String getStreamingPaddingSchemeName() {
        return this.streamingPaddingSchemeName;
    }

    public void setStreamingPaddingSchemeName(String streamingPaddingSchemeName) {
        this.streamingPaddingSchemeName = streamingPaddingSchemeName;
        this.streamingTransformationString = null;
    }

    public void setStreamingPaddingScheme(PaddingScheme scheme) {
        this.setStreamingPaddingSchemeName(scheme.getTransformationName());
    }

    public int getStreamingBlockSize() {
        return this.streamingBlockSize;
    }

    public void setStreamingBlockSize(int streamingBlockSize) {
        this.streamingBlockSize = Math.max(0, streamingBlockSize);
        this.streamingTransformationString = null;
    }

    @Override
    protected String getTransformationString(boolean streaming) {
        if (streaming) {
            if (this.streamingTransformationString == null) {
                this.streamingTransformationString = this.buildStreamingTransformationString();
            }
            return this.streamingTransformationString;
        }
        if (this.transformationString == null) {
            this.transformationString = this.buildTransformationString();
        }
        return this.transformationString;
    }

    private String buildTransformationString() {
        return this.buildTransformationString(this.getModeName(), this.getPaddingSchemeName(), this.getBlockSize());
    }

    private String buildStreamingTransformationString() {
        return this.buildTransformationString(this.getStreamingModeName(), this.getStreamingPaddingSchemeName(), 0);
    }

    private String buildTransformationString(String modeName, String paddingSchemeName, int blockSize) {
        StringBuilder sb = new StringBuilder(this.getAlgorithmName());
        if (StringUtils.hasText((String)modeName)) {
            sb.append(TRANSFORMATION_STRING_DELIMITER).append(modeName);
        }
        if (blockSize > 0) {
            sb.append(blockSize);
        }
        if (StringUtils.hasText((String)paddingSchemeName)) {
            sb.append(TRANSFORMATION_STRING_DELIMITER).append(paddingSchemeName);
        }
        return sb.toString();
    }

    private boolean isModeInitializationVectorCompatible(String modeName) {
        return modeName != null && !modeName.equalsIgnoreCase(OperationMode.ECB.name()) && !modeName.equalsIgnoreCase(OperationMode.NONE.name());
    }

    @Override
    protected boolean isGenerateInitializationVectors(boolean streaming) {
        return streaming || super.isGenerateInitializationVectors() && this.isModeInitializationVectorCompatible(this.getModeName());
    }

    @Override
    protected byte[] generateInitializationVector(boolean streaming) {
        if (streaming) {
            String streamingModeName = this.getStreamingModeName();
            if (!this.isModeInitializationVectorCompatible(streamingModeName)) {
                String msg = "streamingMode attribute value [" + streamingModeName + "] does not support " + "Initialization Vectors.  Ensure the streamingMode value represents an operation mode " + "that is compatible with initialization vectors.";
                throw new IllegalStateException(msg);
            }
        } else {
            String modeName = this.getModeName();
            if (!this.isModeInitializationVectorCompatible(modeName)) {
                String msg = "mode attribute value [" + modeName + "] does not support " + "Initialization Vectors.  Ensure the mode value represents an operation mode " + "that is compatible with initialization vectors.";
                throw new IllegalStateException(msg);
            }
        }
        return super.generateInitializationVector(streaming);
    }
}

