/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis.gradle;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.util.DelegatingScript;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;

public class ForbiddenApisPlugin
implements Plugin<Project> {
    private static final String PLUGIN_INIT_SCRIPT = "plugin-init.groovy";
    public static final String FORBIDDEN_APIS_TASK_NAME = "forbiddenApis";
    public static final String FORBIDDEN_APIS_EXTENSION_NAME = "forbiddenApis";
    public static final GradleVersion MIN_GRADLE_VERSION = GradleVersion.version((String)"2.3");
    private static final String GRADLE_DAEMON_PACKAGE = "org.gradle.launcher.daemon.";
    private static final AtomicBoolean logGradleDaemonWarning = new AtomicBoolean(true);
    private static final Class<? extends DelegatingScript> compiledScript;

    private static boolean isGradleDaemon() {
        if (System.getProperty("sun.java.command", "").startsWith(GRADLE_DAEMON_PACKAGE)) {
            return true;
        }
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            if (!e.getClassName().startsWith(GRADLE_DAEMON_PACKAGE)) continue;
            return true;
        }
        return false;
    }

    private static boolean detectAndLogGradleDaemon(Project project) {
        boolean daemon = ForbiddenApisPlugin.isGradleDaemon();
        if (daemon && logGradleDaemonWarning.getAndSet(false)) {
            project.getLogger().info("You are running forbidden-apis in the Gradle Daemon; disabling classloading cache by default to work around resource leak.");
        }
        return daemon;
    }

    public void apply(Project project) {
        DelegatingScript script;
        if (GradleVersion.current().compareTo(MIN_GRADLE_VERSION) < 0) {
            throw new GradleException("Forbiddenapis plugin requires at least " + MIN_GRADLE_VERSION + ", running version is " + GradleVersion.current());
        }
        try {
            script = compiledScript.newInstance();
        }
        catch (Exception e) {
            throw new GradleException("Cannot instantiate Groovy script to apply forbiddenapis plugin.", (Throwable)e);
        }
        script.setDelegate((Object)this);
        script.setProperty("project", (Object)project);
        script.setProperty("isGradleDaemon", (Object)ForbiddenApisPlugin.detectAndLogGradleDaemon(project));
        script.run();
    }

    static {
        ImportCustomizer importCustomizer = new ImportCustomizer().addStarImports(new String[]{ForbiddenApisPlugin.class.getPackage().getName()});
        final CompilerConfiguration configuration = new CompilerConfiguration().addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        configuration.setScriptBaseClass(DelegatingScript.class.getName());
        configuration.setSourceEncoding("UTF-8");
        final URL scriptUrl = ForbiddenApisPlugin.class.getResource(PLUGIN_INIT_SCRIPT);
        if (scriptUrl == null) {
            throw new RuntimeException("Cannot find resource with script: plugin-init.groovy");
        }
        compiledScript = AccessController.doPrivileged(new PrivilegedAction<Class<? extends DelegatingScript>>(){

            @Override
            public Class<? extends DelegatingScript> run() {
                try {
                    GroovyClassLoader loader = new GroovyClassLoader(ForbiddenApisPlugin.class.getClassLoader(), configuration);
                    GroovyCodeSource csrc = new GroovyCodeSource(scriptUrl);
                    Class<DelegatingScript> clazz = loader.parseClass(csrc, false).asSubclass(DelegatingScript.class);
                    return clazz;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot compile Groovy script: plugin-init.groovy");
                }
            }
        });
    }
}

