/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify;

import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyRequestContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyRequestStatesEnum;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyRequest;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyRequestImpl;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordModifyRequestGrammar
extends AbstractGrammar<PasswordModifyRequestContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordModifyRequestGrammar.class);
    private static Grammar<PasswordModifyRequestContainer> instance = new PasswordModifyRequestGrammar();

    public PasswordModifyRequestGrammar() {
        this.setName(PasswordModifyRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[PasswordModifyRequestStatesEnum.LAST_PASSWORD_MODIFY_REQUEST_STATE.ordinal()][256];
        this.transitions[PasswordModifyRequestStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)PasswordModifyRequestStatesEnum.START_STATE, (Enum)PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<PasswordModifyRequestContainer>("Init PasswordModifyRequest"){

            public void action(PasswordModifyRequestContainer container) {
                PasswordModifyRequestDecorator passwordModifyRequestDecorator = new PasswordModifyRequestDecorator(LdapApiServiceFactory.getSingleton(), (PasswordModifyRequest)new PasswordModifyRequestImpl());
                container.setPasswordModifyRequest(passwordModifyRequestDecorator);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition((Enum)PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE, (Enum)PasswordModifyRequestStatesEnum.USER_IDENTITY_STATE, 128, (Action)new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest user identity"){

            public void action(PasswordModifyRequestContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] userIdentity = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08217_USER_IDENTITY, (Object[])new Object[]{Strings.dumpBytes((byte[])userIdentity)}));
                }
                if (userIdentity == null) {
                    userIdentity = Strings.EMPTY_BYTES;
                }
                container.getPwdModifyRequest().setUserIdentity(userIdentity);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.USER_IDENTITY_STATE.ordinal()][129] = new GrammarTransition((Enum)PasswordModifyRequestStatesEnum.USER_IDENTITY_STATE, (Enum)PasswordModifyRequestStatesEnum.OLD_PASSWORD_STATE, 129, (Action)new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest oldPassword"){

            public void action(PasswordModifyRequestContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] oldPassword = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08209_OLD_PASSWORD, (Object[])new Object[0]));
                }
                if (oldPassword == null) {
                    oldPassword = Strings.EMPTY_BYTES;
                }
                container.getPwdModifyRequest().setOldPassword(oldPassword);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.USER_IDENTITY_STATE.ordinal()][130] = new GrammarTransition((Enum)PasswordModifyRequestStatesEnum.USER_IDENTITY_STATE, (Enum)PasswordModifyRequestStatesEnum.NEW_PASSWORD_STATE, 130, (Action)new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest newPassword"){

            public void action(PasswordModifyRequestContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] newPassword = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08208_NEW_PASSWORD, (Object[])new Object[0]));
                }
                if (newPassword == null) {
                    newPassword = Strings.EMPTY_BYTES;
                }
                container.getPwdModifyRequest().setNewPassword(newPassword);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE.ordinal()][129] = new GrammarTransition((Enum)PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE, (Enum)PasswordModifyRequestStatesEnum.OLD_PASSWORD_STATE, 129, (Action)new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest oldPassword"){

            public void action(PasswordModifyRequestContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] oldPassword = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08209_OLD_PASSWORD, (Object[])new Object[0]));
                }
                if (oldPassword == null) {
                    oldPassword = Strings.EMPTY_BYTES;
                }
                container.getPwdModifyRequest().setOldPassword(oldPassword);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE.ordinal()][130] = new GrammarTransition((Enum)PasswordModifyRequestStatesEnum.PASSWORD_MODIFY_REQUEST_SEQUENCE_STATE, (Enum)PasswordModifyRequestStatesEnum.NEW_PASSWORD_STATE, 130, (Action)new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest newPassword"){

            public void action(PasswordModifyRequestContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] newPassword = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08208_NEW_PASSWORD, (Object[])new Object[0]));
                }
                if (newPassword == null) {
                    newPassword = Strings.EMPTY_BYTES;
                }
                container.getPwdModifyRequest().setNewPassword(newPassword);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyRequestStatesEnum.OLD_PASSWORD_STATE.ordinal()][130] = new GrammarTransition((Enum)PasswordModifyRequestStatesEnum.OLD_PASSWORD_STATE, (Enum)PasswordModifyRequestStatesEnum.NEW_PASSWORD_STATE, 130, (Action)new GrammarAction<PasswordModifyRequestContainer>("Set PasswordModifyRequest newPassword"){

            public void action(PasswordModifyRequestContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] newPassword = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08208_NEW_PASSWORD, (Object[])new Object[0]));
                }
                if (newPassword == null) {
                    newPassword = Strings.EMPTY_BYTES;
                }
                container.getPwdModifyRequest().setNewPassword(newPassword);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<PasswordModifyRequestContainer> getInstance() {
        return instance;
    }
}

