/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import org.apache.commons.lang.NotImplementedException;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.ReferralHandlingMode;
import org.apache.directory.server.core.api.interceptor.context.AbstractOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindOperationContext
extends AbstractOperationContext {
    private static final Logger LOG = LoggerFactory.getLogger(BindOperationContext.class);
    private byte[] credentials;
    private String saslMechanism;
    private String saslAuthId;
    private boolean collateralOperation;
    private ReferralHandlingMode referralHandlingMode;
    private IoSession ioSession;

    public BindOperationContext(CoreSession session) {
        super(session);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.BIND));
        }
    }

    public AuthenticationLevel getAuthenticationLevel() throws LdapAuthenticationException {
        if (this.saslMechanism == null) {
            if (Dn.isNullOrEmpty((Dn)this.dn)) {
                if (Strings.isEmpty((byte[])this.credentials)) {
                    return AuthenticationLevel.NONE;
                }
                LOG.info("Bad authentication for {}", (Object)this.dn);
                throw new LdapAuthenticationException("Invalid authentication");
            }
            if (Strings.isEmpty((byte[])this.credentials)) {
                return AuthenticationLevel.UNAUTHENT;
            }
            return AuthenticationLevel.SIMPLE;
        }
        return AuthenticationLevel.STRONG;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public void setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public byte[] getCredentials() {
        return this.credentials;
    }

    public void setCredentials(byte[] credentials) {
        this.credentials = credentials;
    }

    public String getSaslAuthId() {
        return this.saslAuthId;
    }

    public void setSaslAuthId(String saslAuthId) {
        this.saslAuthId = saslAuthId;
    }

    public boolean isSaslBind() {
        return this.saslMechanism != null;
    }

    @Override
    public String getName() {
        return MessageTypeEnum.BIND_REQUEST.name();
    }

    public String toString() {
        return "BindContext for Dn '" + this.getDn().getName() + "', credentials <" + (this.credentials != null ? Strings.dumpBytes((byte[])this.credentials) : "") + ">" + (this.saslMechanism != null ? ", saslMechanism : <" + this.saslMechanism + ">" : "") + (this.saslAuthId != null ? ", saslAuthId <" + this.saslAuthId + ">" : "");
    }

    public boolean isCollateralOperation() {
        return this.collateralOperation;
    }

    public void setCollateralOperation(boolean collateralOperation) {
        this.collateralOperation = collateralOperation;
    }

    public ReferralHandlingMode getReferralHandlingMode() {
        return this.referralHandlingMode;
    }

    public void setReferralHandlingMode(ReferralHandlingMode referralHandlingMode) {
        this.referralHandlingMode = referralHandlingMode;
    }

    @Override
    public void throwReferral() {
        throw new NotImplementedException(I18n.err((I18n)I18n.ERR_320, (Object[])new Object[0]));
    }

    @Override
    public boolean isReferralThrown() {
        throw new NotImplementedException(I18n.err((I18n)I18n.ERR_321, (Object[])new Object[0]));
    }

    @Override
    public void ignoreReferral() {
        throw new NotImplementedException(I18n.err((I18n)I18n.ERR_322, (Object[])new Object[0]));
    }

    @Override
    public boolean isReferralIgnored() {
        throw new NotImplementedException(I18n.err((I18n)I18n.ERR_323, (Object[])new Object[0]));
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    public void setIoSession(IoSession ioSession) {
        this.ioSession = ioSession;
    }
}

