/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.dispatch.DefaultDispatch;

public class URLDecodingDispatch
extends DefaultDispatch {
    @Override
    public URI getDispatchUrl(HttpServletRequest request) {
        String decoded;
        try {
            decoded = URLDecoder.decode(request.getRequestURL().toString(), StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            decoded = request.getRequestURL().toString();
        }
        StringBuilder str = new StringBuilder(decoded);
        String query = request.getQueryString();
        if (query != null) {
            str.append('?');
            str.append(query);
        }
        return URI.create(str.toString());
    }
}

