/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.net.ntp.TimeStamp;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.services.security.impl.ConfigurableEncryptor;

public class CMFMasterService {
    private static GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private static final String MASTER_PASSPHRASE = "masterpassphrase";
    private static final String MASTER_PERSISTENCE_TAG = "#1.0# " + TimeStamp.getCurrentTime().toDateString();
    protected char[] master;
    protected String serviceName;
    private ConfigurableEncryptor encryptor = new ConfigurableEncryptor("masterpassphrase");

    public CMFMasterService(String serviceName) {
        this.serviceName = serviceName;
    }

    public char[] getMasterSecret() {
        return this.master;
    }

    public void setupMasterSecret(String securityDir, String filename, boolean persisting, GatewayConfig config) throws ServiceLifecycleException {
        this.encryptor.init(config);
        this.setupMasterSecret(securityDir, filename, persisting);
    }

    protected void setupMasterSecret(String securityDir, boolean persisting) throws ServiceLifecycleException {
        this.setupMasterSecret(securityDir, this.serviceName + "-master", persisting);
    }

    protected void setupMasterSecret(String securityDir, String filename, boolean persisting) throws ServiceLifecycleException {
        File masterFile = new File(securityDir, filename);
        if (masterFile.exists()) {
            try {
                this.initializeFromMaster(masterFile);
            }
            catch (Exception e) {
                throw new ServiceLifecycleException("Unable to load the persisted master secret.", e);
            }
        } else {
            if (this.master == null) {
                this.displayWarning(persisting);
                this.promptUser();
            }
            if (persisting) {
                this.persistMaster(this.master, masterFile);
            }
        }
    }

    protected void promptUser() {
        Console c = System.console();
        if (c == null) {
            LOG.unableToPromptForMasterUseKnoxCLI();
            System.err.println("No console.");
            System.exit(1);
        }
        boolean valid = false;
        do {
            char[] newPassword1 = c.readPassword("Enter master secret: ", new Object[0]);
            char[] newPassword2 = c.readPassword("Enter master secret again: ", new Object[0]);
            if (newPassword1.length == 0) {
                c.format("Password too short. Try again.%n", new Object[0]);
            } else if (!Arrays.equals(newPassword1, newPassword2)) {
                c.format("Passwords don't match. Try again.%n", new Object[0]);
            } else {
                this.master = Arrays.copyOf(newPassword1, newPassword1.length);
                valid = true;
            }
            Arrays.fill(newPassword1, ' ');
            Arrays.fill(newPassword2, ' ');
        } while (!valid);
    }

    protected void displayWarning(boolean persisting) {
        Console c = System.console();
        if (c == null) {
            LOG.unableToPromptForMasterUseKnoxCLI();
            System.err.println("No console.");
            System.exit(1);
        }
        if (persisting) {
            c.printf("***************************************************************************************************\n", new Object[0]);
            c.printf("You have indicated that you would like to persist the master secret for this service instance.\n", new Object[0]);
            c.printf("Be aware that this is less secure than manually entering the secret on startup.\n", new Object[0]);
            c.printf("The persisted file will be encrypted and primarily protected through OS permissions.\n", new Object[0]);
            c.printf("***************************************************************************************************\n", new Object[0]);
        } else {
            c.printf("***************************************************************************************************\n", new Object[0]);
            c.printf("Be aware that you will need to enter your master secret for future starts exactly as you do here.\n", new Object[0]);
            c.printf("This secret is needed to access protected resources for the service process.\n", new Object[0]);
            c.printf("The master secret must be protected, kept secret and not stored in clear text anywhere.\n", new Object[0]);
            c.printf("***************************************************************************************************\n", new Object[0]);
        }
    }

    protected void persistMaster(char[] master, File masterFile) {
        EncryptionResult atom = this.encryptMaster(master);
        try {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(MASTER_PERSISTENCE_TAG);
            String line = Base64.encodeBase64String((byte[])(Base64.encodeBase64String((byte[])atom.salt) + "::" + Base64.encodeBase64String((byte[])atom.iv) + "::" + Base64.encodeBase64String((byte[])atom.cipher)).getBytes(StandardCharsets.UTF_8));
            lines.add(line);
            FileUtils.writeLines((File)masterFile, (String)StandardCharsets.UTF_8.name(), lines);
            this.chmod("600", masterFile);
        }
        catch (IOException e) {
            LOG.failedToPersistMasterSecret(e);
        }
    }

    private EncryptionResult encryptMaster(char[] master) {
        try {
            return this.encryptor.encrypt(new String(master));
        }
        catch (Exception e) {
            LOG.failedToEncryptMasterSecret(e);
            return null;
        }
    }

    protected void initializeFromMaster(File masterFile) throws Exception {
        try {
            List lines = FileUtils.readLines((File)masterFile, (Charset)StandardCharsets.UTF_8);
            String tag = (String)lines.get(0);
            LOG.loadingFromPersistentMaster(tag);
            String line = new String(Base64.decodeBase64((String)((String)lines.get(1))), StandardCharsets.UTF_8);
            String[] parts = line.split("::");
            this.master = new String(this.encryptor.decrypt(Base64.decodeBase64((String)parts[0]), Base64.decodeBase64((String)parts[1]), Base64.decodeBase64((String)parts[2])), StandardCharsets.UTF_8).toCharArray();
        }
        catch (Exception e) {
            LOG.failedToInitializeFromPersistentMaster(masterFile.getName(), e);
            throw e;
        }
    }

    private void chmod(String args, File file) throws IOException {
        if (this.isUnixEnv()) {
            if (args == null || file == null) {
                throw new IllegalArgumentException("nullArg");
            }
            if (!file.exists()) {
                throw new IOException("fileNotFound");
            }
            String[] argsString = args.split(" +");
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("/bin/chmod");
            cmdList.addAll(Arrays.asList(argsString));
            cmdList.add(file.getAbsolutePath());
            new ProcessBuilder(cmdList).start();
        }
    }

    private boolean isUnixEnv() {
        return File.separatorChar == '/';
    }
}

