/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hbase;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class HBaseUIServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "HBASEUI";
    private static final String SERVICE_TYPE = "HBASE";
    private static final String ROLE_TYPE = "MASTER";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return SERVICE_TYPE.equals(service.getType()) && ROLE_TYPE.equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String hostname = role.getHostRef().getHostname();
        String port = this.getRoleConfigValue(roleConfig, "hbase_master_info_port");
        boolean sslEnabled = Boolean.parseBoolean(this.getServiceConfigValue(serviceConfig, "hbase_hadoop_ssl_enabled"));
        String scheme = sslEnabled ? "https" : "http";
        return new ServiceModel(ServiceModel.Type.UI, SERVICE, String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
    }
}

