/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.AttributeValueAssertion;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAttributeDescFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAttributeDescFilter.class);

    public InitAttributeDescFilter() {
        super("Initialize AttributeDesc filter");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        AttributeValueAssertion assertion = new AttributeValueAssertion();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05135_EMPTY_ATTRIBUTE_DESCRIPTION, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        String type = Strings.utf8ToString((byte[])tlv.getValue().getData());
        assertion.setAttributeDesc(type);
        AttributeValueAssertionFilter terminalFilter = (AttributeValueAssertionFilter)searchRequestDecorator.getTerminalFilter();
        terminalFilter.setAssertion(assertion);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05143_INITIALIZE_ATT_DESC_FILTER, (Object[])new Object[0]));
        }
    }
}

