/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.ha.dispatch.DefaultHaDispatch;

public class AtlasTrustedProxyHaDispatch
extends DefaultHaDispatch {
    public AtlasTrustedProxyHaDispatch() {
        this.setServiceRole("ATLAS");
    }

    @Override
    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            int sc = inboundResponse.getStatusLine().getStatusCode();
            if (!(sc != 302 && sc != 307 || this.isLoginRedirect(inboundResponse.getFirstHeader("Location")))) {
                inboundResponse.removeHeaders("Location");
                this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, new Exception("Atlas HA redirection"));
            }
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (IOException e) {
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    private boolean isLoginRedirect(Header locationHeader) {
        boolean result = false;
        if (locationHeader != null) {
            String value = locationHeader.getValue();
            result = value.endsWith("login.jsp") || value.contains("originalUrl");
        }
        return result;
    }
}

