/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.Optional;
import org.apache.knox.gateway.dispatch.DefaultDispatch;
import org.apache.knox.gateway.ha.dispatch.i18n.HaDispatchMessages;
import org.apache.knox.gateway.ha.provider.HaProvider;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class DefaultHaDispatch
extends DefaultDispatch {
    protected static final String FAILOVER_COUNTER_ATTRIBUTE = "dispatch.ha.failover.counter";
    protected static final HaDispatchMessages LOG = (HaDispatchMessages)MessagesFactory.get(HaDispatchMessages.class);
    private int maxFailoverAttempts = 3;
    private int failoverSleep = 1000;
    private HaProvider haProvider;
    @Optional
    @Configure
    private String serviceRole;

    public void init() {
        super.init();
        LOG.initializingForResourceRole(this.getServiceRole());
        if (this.haProvider != null) {
            HaServiceConfig serviceConfig = this.haProvider.getHaDescriptor().getServiceConfig(this.getServiceRole());
            this.maxFailoverAttempts = serviceConfig.getMaxFailoverAttempts();
            this.failoverSleep = serviceConfig.getFailoverSleep();
        }
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public HaProvider getHaProvider() {
        return this.haProvider;
    }

    @Configure
    public void setHaProvider(HaProvider haProvider) {
        this.haProvider = haProvider;
    }

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (IOException e) {
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    protected void failoverRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse, Exception exception) throws IOException {
        LOG.failingOverRequest(outboundRequest.getURI().toString());
        AtomicInteger counter = (AtomicInteger)inboundRequest.getAttribute(FAILOVER_COUNTER_ATTRIBUTE);
        if (counter == null) {
            counter = new AtomicInteger(0);
        }
        inboundRequest.setAttribute(FAILOVER_COUNTER_ATTRIBUTE, (Object)counter);
        if (counter.incrementAndGet() <= this.maxFailoverAttempts) {
            this.haProvider.markFailedURL(this.getServiceRole(), outboundRequest.getURI().toString());
            inboundRequest.setAttribute("targetRequestUrl", null);
            URI uri = this.getDispatchUrl(inboundRequest);
            ((HttpRequestBase)outboundRequest).setURI(uri);
            if (this.failoverSleep > 0) {
                try {
                    Thread.sleep(this.failoverSleep);
                }
                catch (InterruptedException e) {
                    LOG.failoverSleepFailed(this.getServiceRole(), e);
                }
            }
            this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
        } else {
            LOG.maxFailoverAttemptsReached(this.maxFailoverAttempts, this.getServiceRole());
            if (inboundResponse != null) {
                this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
            } else {
                throw new IOException(exception);
            }
        }
    }
}

