/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.config;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.vault.config.ClientHttpRequestFactoryFactory;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import reactor.netty.http.client.HttpClient;

public class ClientHttpConnectorFactory {
    public static ClientHttpConnector create(ClientOptions options, SslConfiguration sslConfiguration) {
        HttpClient client = HttpClient.create();
        if (ClientHttpRequestFactoryFactory.hasSslConfiguration(sslConfiguration)) {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
            ClientHttpConnectorFactory.configureSsl(sslConfiguration, sslContextBuilder);
            client = client.secure(builder -> builder.sslContext(sslContextBuilder));
        }
        client = client.tcpConfiguration(it -> it.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(options.getConnectionTimeout().toMillis())));
        return new ReactorClientHttpConnector(client);
    }

    private static void configureSsl(SslConfiguration sslConfiguration, SslContextBuilder sslContextBuilder) {
        try {
            if (sslConfiguration.getTrustStoreConfiguration().isPresent()) {
                sslContextBuilder.trustManager(ClientHttpRequestFactoryFactory.createTrustManagerFactory(sslConfiguration.getTrustStoreConfiguration()));
            }
            if (sslConfiguration.getKeyStoreConfiguration().isPresent()) {
                sslContextBuilder.keyManager(ClientHttpRequestFactoryFactory.createKeyManagerFactory(sslConfiguration.getKeyStoreConfiguration()));
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

