/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model;

import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.model.ApiConfig;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.knox.gateway.topology.discovery.cm.DiscoveryApiClient;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGenerator;

public abstract class AbstractServiceModelGenerator
implements ServiceModelGenerator {
    private DiscoveryApiClient client;

    @Override
    public void setApiClient(DiscoveryApiClient client) {
        this.client = client;
    }

    protected ApiClient getClient() {
        return this.client;
    }

    protected String getServiceConfigValue(ApiServiceConfig serviceConfig, String key) {
        return this.getConfigValue(key, serviceConfig.getItems());
    }

    protected String getRoleConfigValue(ApiConfigList roleConfig, String key) {
        return this.getConfigValue(key, roleConfig.getItems());
    }

    protected String getConfigValue(String key, List<ApiConfig> items) {
        for (ApiConfig config : items) {
            if (!key.equals(config.getName())) continue;
            String value = config.getValue();
            if (value != null) {
                return value;
            }
            return config.getDefault();
        }
        return null;
    }

    protected String getSafetyValveValue(String safetyValve, String key) {
        Pattern p;
        Matcher m;
        String val = null;
        if (safetyValve != null && (m = (p = Pattern.compile("<property><name>" + key + "</name><value>(.*?)</value></property>")).matcher(safetyValve.replaceAll("\\s", ""))).find()) {
            val = m.group(1);
        }
        return val;
    }
}

