/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.j2e.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.j2e.filter.AbstractConfigFilter;
import org.pac4j.j2e.util.Pac4JHttpServletRequestWrapper;

public class SecurityFilter
extends AbstractConfigFilter {
    private SecurityLogic<Object, J2EContext> securityLogic = new DefaultSecurityLogic();
    private String clients;
    private String authorizers;
    private String matchers;
    private Boolean multiProfile;

    public SecurityFilter() {
    }

    public SecurityFilter(Config config) {
        this.setConfig(config);
    }

    public SecurityFilter(Config config, String clients) {
        this(config);
        this.clients = clients;
    }

    public SecurityFilter(Config config, String clients, String authorizers) {
        this(config, clients);
        this.authorizers = authorizers;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.clients = this.getStringParam(filterConfig, "clients", this.clients);
        this.authorizers = this.getStringParam(filterConfig, "authorizers", this.authorizers);
        this.matchers = this.getStringParam(filterConfig, "matchers", this.matchers);
        this.multiProfile = this.getBooleanParam(filterConfig, "multiProfile", this.multiProfile);
        this.checkForbiddenParameter(filterConfig, "clientsFactory");
        this.checkForbiddenParameter(filterConfig, "isAjax");
        this.checkForbiddenParameter(filterConfig, "stateless");
        this.checkForbiddenParameter(filterConfig, "requireAnyRole");
        this.checkForbiddenParameter(filterConfig, "requireAllRoles");
        this.checkForbiddenParameter(filterConfig, "clientName");
        this.checkForbiddenParameter(filterConfig, "authorizerName");
        this.checkForbiddenParameter(filterConfig, "matcherName");
    }

    @Override
    protected final void internalFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CommonHelper.assertNotNull((String)"securityLogic", this.securityLogic);
        Config config = this.getConfig();
        CommonHelper.assertNotNull((String)"config", (Object)config);
        J2EContext context = new J2EContext(request, response, config.getSessionStore());
        this.retrieveSecurityLogic().perform((WebContext)context, config, (ctx, profiles, parameters) -> {
            filterChain.doFilter((ServletRequest)(profiles.isEmpty() ? request : new Pac4JHttpServletRequestWrapper(request, profiles)), (ServletResponse)response);
            return null;
        }, this.retrieveHttpActionAdapter(), this.clients, this.authorizers, this.matchers, this.multiProfile, new Object[0]);
    }

    protected SecurityLogic<Object, J2EContext> retrieveSecurityLogic() {
        SecurityLogic configSecurityLogic;
        if (this.getConfig() != null && (configSecurityLogic = this.getConfig().getSecurityLogic()) != null) {
            return configSecurityLogic;
        }
        return this.securityLogic;
    }

    public String getClients() {
        return this.clients;
    }

    public void setClients(String clients) {
        this.clients = clients;
    }

    public String getAuthorizers() {
        return this.authorizers;
    }

    public void setAuthorizers(String authorizers) {
        this.authorizers = authorizers;
    }

    public String getMatchers() {
        return this.matchers;
    }

    public void setMatchers(String matchers) {
        this.matchers = matchers;
    }

    public Boolean getMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public SecurityLogic<Object, J2EContext> getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic<Object, J2EContext> securityLogic) {
        this.securityLogic = securityLogic;
    }
}

