/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.knox.gateway.ha.provider.HaDescriptor;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.ha.provider.impl.HaDescriptorConstants;
import org.apache.knox.gateway.ha.provider.impl.HaDescriptorFactory;
import org.apache.knox.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HaDescriptorManager
implements HaDescriptorConstants {
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);

    public static void store(HaDescriptor descriptor, Writer writer) throws IOException {
        try {
            Document document = XmlUtils.createDocument();
            Element root = document.createElement("ha");
            document.appendChild(root);
            List<HaServiceConfig> serviceConfigs = descriptor.getServiceConfigs();
            if (serviceConfigs != null && !serviceConfigs.isEmpty()) {
                for (HaServiceConfig config : serviceConfigs) {
                    Element serviceElement = document.createElement("service");
                    serviceElement.setAttribute("name", config.getServiceName());
                    serviceElement.setAttribute("maxFailoverAttempts", Integer.toString(config.getMaxFailoverAttempts()));
                    serviceElement.setAttribute("failoverSleep", Integer.toString(config.getFailoverSleep()));
                    serviceElement.setAttribute("maxRetryAttempts", Integer.toString(config.getMaxRetryAttempts()));
                    serviceElement.setAttribute("retrySleep", Integer.toString(config.getRetrySleep()));
                    serviceElement.setAttribute("enabled", Boolean.toString(config.isEnabled()));
                    if (config.getZookeeperEnsemble() != null) {
                        serviceElement.setAttribute("zookeeperEnsemble", config.getZookeeperEnsemble());
                    }
                    if (config.getZookeeperNamespace() != null) {
                        serviceElement.setAttribute("zookeeperNamespace", config.getZookeeperNamespace());
                    }
                    root.appendChild(serviceElement);
                }
            }
            Transformer t = XmlUtils.getTransformer((boolean)true, (boolean)true, (int)2, (boolean)false);
            XmlUtils.writeXml((Document)document, (Writer)writer, (Transformer)t);
        }
        catch (ParserConfigurationException | TransformerException e) {
            LOG.failedToWriteHaDescriptor(e);
            throw new IOException(e);
        }
    }

    public static HaDescriptor load(InputStream inputStream) throws IOException {
        HaDescriptor descriptor = HaDescriptorFactory.createDescriptor();
        try {
            Document document = XmlUtils.readXml((InputStream)inputStream);
            NodeList nodeList = document.getElementsByTagName("service");
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    HaServiceConfig config = HaDescriptorFactory.createServiceConfig(element.getAttribute("name"), element.getAttribute("enabled"), element.getAttribute("maxFailoverAttempts"), element.getAttribute("failoverSleep"), element.getAttribute("maxRetryAttempts"), element.getAttribute("retrySleep"), element.getAttribute("zookeeperEnsemble"), element.getAttribute("zookeeperNamespace"));
                    descriptor.addServiceConfig(config);
                }
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            LOG.failedToLoadHaDescriptor(e);
            throw new IOException(e);
        }
        return descriptor;
    }
}

