/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.config;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.state.StateGenerator;
import org.pac4j.core.state.StaticOrRandomStateGenerator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuthConfiguration;

public class OAuth20Configuration
extends OAuthConfiguration<OAuth20Service, OAuth2AccessToken> {
    public static final String OAUTH_CODE = "code";
    public static final String STATE_REQUEST_PARAMETER = "state";
    private static final String STATE_SESSION_PARAMETER = "#oauth20StateParameter";
    private Map<String, String> customParams = new HashMap<String, String>();
    private boolean withState;
    private StateGenerator stateGenerator = new StaticOrRandomStateGenerator();

    public String getStateSessionAttributeName(String clientName) {
        return clientName + STATE_SESSION_PARAMETER;
    }

    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, String> customParams) {
        this.customParams = customParams;
    }

    public boolean isWithState() {
        return this.withState;
    }

    public void setWithState(boolean withState) {
        this.withState = withState;
    }

    @Deprecated
    public String getStateData() {
        return ((StaticOrRandomStateGenerator)this.stateGenerator).getStateData();
    }

    @Deprecated
    public void setStateData(String stateData) {
        ((StaticOrRandomStateGenerator)this.stateGenerator).setStateData(stateData);
    }

    public StateGenerator getStateGenerator() {
        return this.stateGenerator;
    }

    public void setStateGenerator(StateGenerator stateGenerator) {
        CommonHelper.assertNotNull((String)"stateGenerator", (Object)stateGenerator);
        this.stateGenerator = stateGenerator;
    }
}

