/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.javascript;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.regex.Pattern;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterPathDescriptor;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFilterReader;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteUtil;

public abstract class JavaScriptFilterReader
extends Reader
implements UrlRewriteFilterReader {
    private static final UrlRewriteFilterPathDescriptor.Compiler<Pattern> REGEX_COMPILER = new UrlRewriteFilterReader.RegexCompiler();
    private BufferedReader reader;
    private int offset;
    private StringWriter writer;
    private StringBuffer buffer;
    private UrlRewriteFilterContentDescriptor config;

    protected JavaScriptFilterReader(Reader reader, UrlRewriteFilterContentDescriptor config) throws IOException {
        this.reader = new BufferedReader(reader);
        this.config = config;
        this.writer = new StringWriter();
        this.buffer = this.writer.getBuffer();
        this.offset = 0;
    }

    @Override
    public abstract String filterValueString(String var1, String var2, String var3);

    @Override
    public int read(char[] destBuffer, int destOffset, int destCount) throws IOException {
        int count = 0;
        int available = this.buffer.length() - this.offset;
        if (available == 0) {
            String cbuff = this.reader.readLine();
            if (cbuff != null) {
                count = cbuff.length();
                this.writer.write(UrlRewriteUtil.filterJavaScript(cbuff, this.config, this, REGEX_COMPILER));
                this.writer.write(10);
                available = this.buffer.length() - this.offset;
            } else {
                count = -1;
            }
        }
        if (available > 0) {
            count = Math.min(destCount, available);
            this.buffer.getChars(this.offset, this.offset + count, destBuffer, destOffset);
            this.offset += count;
            if (this.offset == this.buffer.length()) {
                this.offset = 0;
                this.buffer.setLength(0);
            }
        }
        return count;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.writer.close();
    }
}

