/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.phoenix;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class PhoenixServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "AVATICA";
    public static final String SERVICE_TYPE = "PHOENIX";
    public static final String ROLE_TYPE = "PHOENIX_QUERY_SERVER";
    static final String SSL_ENABLED = "ssl_enabled";
    static final String QUERY_SERVER_PORT = "phoenix_query_server_port";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String hostname = role.getHostRef().getHostname();
        String sslEnabledRaw = this.getRoleConfigValue(roleConfig, SSL_ENABLED);
        String scheme = "http";
        if (Boolean.parseBoolean(sslEnabledRaw)) {
            scheme = "https";
        }
        String port = this.getRoleConfigValue(roleConfig, QUERY_SERVER_PORT);
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), QUERY_SERVER_PORT, port);
        if (sslEnabledRaw != null) {
            model.addRoleProperty(this.getRoleType(), SSL_ENABLED, sslEnabledRaw);
        }
        return model;
    }
}

