/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.builder.property.interpreter;

import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.topology.Param;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.builder.property.interpreter.AbstractInterpreter;
import org.apache.knox.gateway.topology.builder.property.interpreter.InterpretException;

public class ProviderParameterPropertyInterpreter
extends AbstractInterpreter {
    private static GatewayResources gatewayResources = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private Provider provider;

    public ProviderParameterPropertyInterpreter(Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(gatewayResources.providerIsRequiredError());
        }
        this.provider = provider;
    }

    @Override
    public void interpret(String token, String value) throws InterpretException {
        if (token == null || token.isEmpty()) {
            throw new InterpretException(gatewayResources.providerParameterNameIsRequiredError());
        }
        if (value == null || value.isEmpty()) {
            throw new InterpretException(gatewayResources.providerParameterValueIsRequiredError());
        }
        Param param = new Param();
        param.setName(token);
        param.setValue(value);
        this.provider.addParam(param);
    }
}

