/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.util;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class X509CertificateUtils {
    public static boolean hasMatchingIssuerAndSubject(X509Certificate cert) {
        Principal issuer = cert.getIssuerDN();
        Principal subject = cert.getSubjectDN();
        return issuer != null && subject != null && issuer.equals(subject);
    }

    public static boolean isSelfIssued(X509Certificate cert) {
        return X509CertificateUtils.hasMatchingIssuerAndSubject(cert) && X509CertificateUtils.isSelfSigned(cert);
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        PublicKey publicKey = cert.getPublicKey();
        return X509CertificateUtils.hasValidSignature(cert, publicKey);
    }

    public static boolean hasValidSignature(X509Certificate cert, PublicKey pubKey) {
        try {
            cert.verify(pubKey);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean publicKeyMatches(X509Certificate cert, PublicKey pubKey) {
        PublicKey certPubKey = cert.getPublicKey();
        return Arrays.equals(certPubKey.getEncoded(), pubKey.getEncoded());
    }

    private X509CertificateUtils() {
    }
}

