/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.cache.Cache;
import org.ldaptive.handler.OperationExceptionHandler;
import org.ldaptive.handler.OperationResponseHandler;
import org.ldaptive.handler.SearchEntryHandler;

public class SearchExecutor
extends SearchRequest {
    private OperationExceptionHandler<SearchRequest, SearchResult> searchExceptionHandler;
    private OperationResponseHandler<SearchRequest, SearchResult>[] searchResponseHandlers;
    private Cache<SearchRequest> searchCache;

    public OperationExceptionHandler<SearchRequest, SearchResult> getSearchExceptionHandler() {
        return this.searchExceptionHandler;
    }

    public void setSearchExceptionHandler(OperationExceptionHandler<SearchRequest, SearchResult> handler) {
        this.searchExceptionHandler = handler;
    }

    public OperationResponseHandler<SearchRequest, SearchResult>[] getSearchResponseHandlers() {
        return this.searchResponseHandlers;
    }

    public void setSearchResponseHandlers(OperationResponseHandler<SearchRequest, SearchResult> ... handlers) {
        this.searchResponseHandlers = handlers;
    }

    public Cache<SearchRequest> getSearchCache() {
        return this.searchCache;
    }

    public void setSearchCache(Cache<SearchRequest> cache) {
        this.searchCache = cache;
    }

    public Response<SearchResult> search(ConnectionFactory factory) throws LdapException {
        return this.search(factory, null, (String[])null, (SearchEntryHandler[])null);
    }

    public Response<SearchResult> search(ConnectionFactory factory, String filter) throws LdapException {
        return this.search(factory, new SearchFilter(filter), (String[])null, (SearchEntryHandler[])null);
    }

    public Response<SearchResult> search(ConnectionFactory factory, SearchFilter filter) throws LdapException {
        return this.search(factory, filter, (String[])null, (SearchEntryHandler[])null);
    }

    public Response<SearchResult> search(ConnectionFactory factory, String filter, String ... attrs) throws LdapException {
        return this.search(factory, new SearchFilter(filter), attrs, (SearchEntryHandler[])null);
    }

    public Response<SearchResult> search(ConnectionFactory factory, SearchFilter filter, String ... attrs) throws LdapException {
        return this.search(factory, filter, attrs, (SearchEntryHandler[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<SearchResult> search(ConnectionFactory factory, SearchFilter filter, String[] attrs, SearchEntryHandler ... handlers) throws LdapException {
        Response<SearchResult> response = null;
        Connection conn = factory.getConnection();
        try {
            conn.open();
            SearchOperation op = new SearchOperation(conn);
            if (this.searchExceptionHandler != null) {
                op.setOperationExceptionHandler(this.searchExceptionHandler);
            }
            if (this.searchResponseHandlers != null) {
                op.setOperationResponseHandlers(this.searchResponseHandlers);
            }
            if (this.searchCache != null) {
                op.setCache(this.searchCache);
            }
            SearchRequest sr = SearchExecutor.newSearchRequest(this);
            if (filter != null) {
                sr.setSearchFilter(filter);
            }
            if (attrs != null) {
                sr.setReturnAttributes(attrs);
            }
            if (handlers != null) {
                sr.setSearchEntryHandlers(handlers);
            }
            response = op.execute(sr);
        }
        finally {
            conn.close();
        }
        return response;
    }
}

