/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.eclipse.persistence.core.descriptors.CoreDescriptorEventManager;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.descriptors.SerializableDescriptorEventHolder;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class DescriptorEventManager
extends CoreDescriptorEventManager<DescriptorEvent>
implements Cloneable,
Serializable {
    protected ClassDescriptor descriptor;
    protected AtomicReferenceArray<String> eventSelectors;
    protected transient AtomicReferenceArray<Method> eventMethods;
    protected transient List<DescriptorEventListener> eventListeners;
    protected transient List<DescriptorEventListener> defaultEventListeners;
    protected transient List<DescriptorEventListener> entityListenerEventListeners;
    protected transient DescriptorEventListener entityEventListener;
    protected transient List<DescriptorEventListener> internalListeners = new ArrayList<DescriptorEventListener>();
    protected transient List<DescriptorEventManager> entityEventManagers;
    protected transient List<DescriptorEventManager> entityListenerEventManagers;
    protected boolean excludeDefaultListeners = false;
    protected boolean excludeSuperclassListeners = false;
    protected List<SerializableDescriptorEventHolder> descriptorEventHolders;
    protected boolean hasAnyEventListeners = false;
    public static final int PreWriteEvent = 0;
    public static final int PostWriteEvent = 1;
    public static final int PreDeleteEvent = 2;
    public static final int PostDeleteEvent = 3;
    public static final int PreInsertEvent = 4;
    public static final int PostInsertEvent = 5;
    public static final int PreUpdateEvent = 6;
    public static final int PostUpdateEvent = 7;
    public static final int PostBuildEvent = 8;
    public static final int PostRefreshEvent = 9;
    public static final int PostCloneEvent = 10;
    public static final int PostMergeEvent = 11;
    public static final int AboutToInsertEvent = 12;
    public static final int AboutToUpdateEvent = 13;
    public static final int AboutToDeleteEvent = 14;
    public static final int PrePersistEvent = 15;
    public static final int PreRemoveEvent = 16;
    public static final int PreUpdateWithChangesEvent = 17;
    protected static final int NumberOfEvents = 18;

    public DescriptorEventManager() {
        this.eventSelectors = DescriptorEventManager.newAtomicReferenceArray(18);
        this.eventMethods = DescriptorEventManager.newAtomicReferenceArray(18);
    }

    public void addDefaultEventListener(DescriptorEventListener listener) {
        this.getDefaultEventListeners().add(listener);
    }

    public void addEntityListenerEventListener(DescriptorEventListener listener) {
        this.getEntityListenerEventListeners().add(listener);
    }

    public void addListener(DescriptorEventListener listener) {
        this.getEventListeners().add(listener);
        this.setHasAnyEventListeners(true);
    }

    public void addInternalListener(DescriptorEventListener listener) {
        if (this.internalListeners == null) {
            this.internalListeners = new ArrayList<DescriptorEventListener>();
        }
        this.internalListeners.add(listener);
        this.setHasAnyEventListeners(true);
    }

    public void addEntityListenerHolder(SerializableDescriptorEventHolder holder) {
        this.getDescriptorEventHolders().add(holder);
    }

    public Object clone() {
        try {
            DescriptorEventManager clone = (DescriptorEventManager)super.clone();
            clone.setEventSelectors(DescriptorEventManager.newAtomicReferenceArray(this.getEventSelectors()));
            clone.setEventMethods(DescriptorEventManager.newAtomicReferenceArray(this.getEventMethods()));
            clone.setEventListeners(this.getEventListeners());
            return clone;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public void processDescriptorEventHolders(AbstractSession session, ClassLoader classLoader) {
        if (this.descriptorEventHolders != null) {
            for (SerializableDescriptorEventHolder holder : this.descriptorEventHolders) {
                holder.addListenerToEventManager(this.getDescriptor(), session, classLoader);
            }
        }
    }

    public boolean excludeDefaultListeners() {
        return this.excludeDefaultListeners;
    }

    public boolean excludeSuperclassListeners() {
        return this.excludeSuperclassListeners;
    }

    @Override
    public void executeEvent(DescriptorEvent event) throws DescriptorException {
        block15: {
            try {
                event.getSession().startOperationProfile("Timer:DescriptorEvents");
                event.setDescriptor(this.getDescriptor());
                this.notifyListeners(event);
                this.notifyEJB30Listeners(event);
                if (event.getSource() instanceof DescriptorEventListener) {
                    this.notifyListener((DescriptorEventListener)event.getSource(), event);
                    return;
                }
                Method eventMethod = this.getEventMethods().get(event.getEventCode());
                if (eventMethod == null) {
                    return;
                }
                try {
                    Object[] runtimeParameters = new Object[]{event};
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(eventMethod, event.getSource(), runtimeParameters));
                            break block15;
                        }
                        catch (PrivilegedActionException exception) {
                            Exception throwableException = exception.getException();
                            if (throwableException instanceof IllegalAccessException) {
                                throw DescriptorException.illegalAccessWhileEventExecution(eventMethod.getName(), this.getDescriptor(), throwableException);
                            }
                            throw DescriptorException.targetInvocationWhileEventExecution(eventMethod.getName(), this.getDescriptor(), throwableException);
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(eventMethod, event.getSource(), runtimeParameters);
                }
                catch (IllegalAccessException exception) {
                    throw DescriptorException.illegalAccessWhileEventExecution(eventMethod.getName(), this.getDescriptor(), exception);
                }
                catch (IllegalArgumentException exception) {
                    throw DescriptorException.illegalArgumentWhileObsoleteEventExecute(eventMethod.getName(), this.getDescriptor(), exception);
                }
                catch (InvocationTargetException exception) {
                    throw DescriptorException.targetInvocationWhileEventExecution(eventMethod.getName(), this.getDescriptor(), exception);
                }
            }
            finally {
                event.getSession().endOperationProfile("Timer:DescriptorEvents");
            }
        }
    }

    protected Method findMethod(int selector) throws DescriptorException {
        Class[] declarationParameters = new Class[]{ClassConstants.DescriptorEvent_Class};
        String methodName = this.getEventSelectors().get(selector);
        try {
            return Helper.getDeclaredMethod(this.getDescriptor().getJavaClass(), methodName, declarationParameters);
        }
        catch (NoSuchMethodException exception) {
            throw DescriptorException.noSuchMethodOnFindObsoleteMethod(methodName, this.getDescriptor(), exception);
        }
        catch (SecurityException exception) {
            throw DescriptorException.securityOnFindMethod(methodName, this.getDescriptor(), exception);
        }
    }

    public String getAboutToDeleteSelector() {
        return this.getEventSelectors().get(14);
    }

    public String getAboutToInsertSelector() {
        return this.getEventSelectors().get(12);
    }

    public String getAboutToUpdateSelector() {
        return this.getEventSelectors().get(13);
    }

    public List<DescriptorEventListener> getDefaultEventListeners() {
        if (this.defaultEventListeners == null) {
            this.defaultEventListeners = new CopyOnWriteArrayList<DescriptorEventListener>();
        }
        return this.defaultEventListeners;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public List<SerializableDescriptorEventHolder> getDescriptorEventHolders() {
        if (this.descriptorEventHolders == null) {
            this.descriptorEventHolders = new CopyOnWriteArrayList<SerializableDescriptorEventHolder>();
        }
        return this.descriptorEventHolders;
    }

    public void setDescriptorEventHolders(List<SerializableDescriptorEventHolder> descriptorEventHolders) {
        this.descriptorEventHolders = descriptorEventHolders;
    }

    public DescriptorEventListener getEntityEventListener() {
        return this.entityEventListener;
    }

    public List<DescriptorEventListener> getEntityListenerEventListeners() {
        if (this.entityListenerEventListeners == null) {
            this.entityListenerEventListeners = new CopyOnWriteArrayList<DescriptorEventListener>();
        }
        return this.entityListenerEventListeners;
    }

    public List<DescriptorEventListener> getEventListeners() {
        if (this.eventListeners == null) {
            this.eventListeners = new CopyOnWriteArrayList<DescriptorEventListener>();
        }
        return this.eventListeners;
    }

    protected AtomicReferenceArray<Method> getEventMethods() {
        if (this.eventMethods == null) {
            this.eventMethods = DescriptorEventManager.newAtomicReferenceArray(18);
        }
        return this.eventMethods;
    }

    protected AtomicReferenceArray<String> getEventSelectors() {
        if (this.eventSelectors == null) {
            this.eventSelectors = DescriptorEventManager.newAtomicReferenceArray(18);
        }
        return this.eventSelectors;
    }

    public String getPostBuildSelector() {
        return this.getEventSelectors().get(8);
    }

    public String getPostCloneSelector() {
        return this.getEventSelectors().get(10);
    }

    public String getPostDeleteSelector() {
        return this.getEventSelectors().get(3);
    }

    public String getPostInsertSelector() {
        return this.getEventSelectors().get(5);
    }

    public String getPostMergeSelector() {
        return this.getEventSelectors().get(11);
    }

    public String getPostRefreshSelector() {
        return this.getEventSelectors().get(9);
    }

    public String getPostUpdateSelector() {
        return this.getEventSelectors().get(7);
    }

    public String getPostWriteSelector() {
        return this.getEventSelectors().get(1);
    }

    public String getPrePersistSelector() {
        return this.getEventSelectors().get(15);
    }

    public String getPreDeleteSelector() {
        return this.getEventSelectors().get(2);
    }

    public String getPreInsertSelector() {
        return this.getEventSelectors().get(4);
    }

    public String getPreRemoveSelector() {
        return this.getEventSelectors().get(16);
    }

    public String getPreUpdateSelector() {
        return this.getEventSelectors().get(6);
    }

    public String getPreWriteSelector() {
        return this.getEventSelectors().get(0);
    }

    @Override
    public boolean hasAnyEventListeners() {
        return this.hasAnyEventListeners || this.hasAnyListeners();
    }

    protected boolean hasAnyListeners() {
        return this.eventListeners != null && !this.eventListeners.isEmpty();
    }

    public boolean hasDefaultEventListeners() {
        return this.defaultEventListeners != null && !this.defaultEventListeners.isEmpty() && !this.excludeDefaultListeners;
    }

    public boolean hasEntityEventListener() {
        return this.entityEventListener != null;
    }

    public boolean hasInternalEventListeners() {
        return this.internalListeners != null && !this.internalListeners.isEmpty();
    }

    public boolean hasEntityListenerEventListeners() {
        return this.entityListenerEventListeners != null && !this.entityListenerEventListeners.isEmpty();
    }

    public void initialize(AbstractSession session) {
        this.setHasAnyEventListeners(false);
        this.initializeEJB30EventManagers();
        if (this.hasEntityEventListener() || this.hasEntityListenerEventListeners() || this.hasDefaultEventListeners() || this.hasInternalEventListeners()) {
            this.setHasAnyEventListeners(true);
        }
        if (this.hasAnyListeners() || DescriptorEventListener.class.isAssignableFrom(this.getDescriptor().getJavaClass())) {
            this.setHasAnyEventListeners(true);
        }
        AtomicReferenceArray<String> selectors = this.getEventSelectors();
        int index = 0;
        while (index < 18) {
            if (selectors.get(index) != null) {
                this.setHasAnyEventListeners(true);
                this.getEventMethods().set(index, this.findMethod(index));
            }
            ++index;
        }
        if (this.getDescriptor().isChildDescriptor()) {
            DescriptorEventManager parentEventManager = this.getDescriptor().getInheritancePolicy().getParentDescriptor().getEventManager();
            if (parentEventManager.hasAnyEventListeners()) {
                this.setHasAnyEventListeners(true);
            }
            int index2 = 0;
            while (index2 < 18) {
                if (selectors.get(index2) == null && parentEventManager.getEventSelectors().get(index2) != null) {
                    this.setHasAnyEventListeners(true);
                    selectors.set(index2, parentEventManager.getEventSelectors().get(index2));
                    this.getEventMethods().set(index2, parentEventManager.getEventMethods().get(index2));
                }
                ++index2;
            }
        }
    }

    protected void initializeEJB30EventManagers() {
        this.entityEventManagers = new CopyOnWriteArrayList<DescriptorEventManager>();
        this.entityListenerEventManagers = new CopyOnWriteArrayList<DescriptorEventManager>();
        if (this.hasEntityEventListener()) {
            this.entityEventManagers.add(this);
        }
        if (this.hasEntityListenerEventListeners()) {
            this.entityListenerEventManagers.add(this);
        }
        ClassDescriptor currentDescriptor = this.getDescriptor();
        boolean excludeEntityListeners = this.excludeSuperclassListeners();
        while (currentDescriptor.isChildDescriptor()) {
            DescriptorEventManager eventManager = (currentDescriptor = currentDescriptor.getInheritancePolicy().getParentDescriptor()).getEventManager();
            if (eventManager.hasEntityEventListener()) {
                this.entityEventManagers.add(eventManager);
            }
            if (eventManager.hasEntityListenerEventListeners() && !excludeEntityListeners) {
                this.entityListenerEventManagers.add(eventManager);
            }
            excludeEntityListeners = eventManager.excludeSuperclassListeners();
        }
    }

    protected void notifyEJB30Listeners(DescriptorEvent event) {
        if (this.hasDefaultEventListeners()) {
            int i = 0;
            while (i < this.getDefaultEventListeners().size()) {
                DescriptorEventListener listener = this.getDefaultEventListeners().get(i);
                this.notifyListener(listener, event);
                ++i;
            }
        }
        int index = this.entityListenerEventManagers.size() - 1;
        while (index >= 0) {
            List<DescriptorEventListener> entityListenerEventListeners = this.entityListenerEventManagers.get(index).getEntityListenerEventListeners();
            int i = 0;
            while (i < entityListenerEventListeners.size()) {
                DescriptorEventListener listener = entityListenerEventListeners.get(i);
                this.notifyListener(listener, event);
                ++i;
            }
            --index;
        }
        index = this.entityEventManagers.size() - 1;
        while (index >= 0) {
            DescriptorEventListener entityEventListener = this.entityEventManagers.get(index).getEntityEventListener();
            if (!entityEventListener.isOverriddenEvent(event, this.entityEventManagers)) {
                this.notifyListener(entityEventListener, event);
            }
            --index;
        }
        if (this.internalListeners != null) {
            for (DescriptorEventListener listener : this.internalListeners) {
                this.notifyListener(listener, event);
            }
        }
    }

    protected void notifyListener(DescriptorEventListener listener, DescriptorEvent event) throws DescriptorException {
        switch (event.getEventCode()) {
            case 0: {
                listener.preWrite(event);
                break;
            }
            case 1: {
                listener.postWrite(event);
                break;
            }
            case 2: {
                listener.preDelete(event);
                break;
            }
            case 3: {
                listener.postDelete(event);
                break;
            }
            case 4: {
                listener.preInsert(event);
                break;
            }
            case 5: {
                listener.postInsert(event);
                break;
            }
            case 6: {
                listener.preUpdate(event);
                break;
            }
            case 7: {
                listener.postUpdate(event);
                break;
            }
            case 11: {
                listener.postMerge(event);
                break;
            }
            case 10: {
                listener.postClone(event);
                break;
            }
            case 8: {
                listener.postBuild(event);
                break;
            }
            case 9: {
                listener.postRefresh(event);
                break;
            }
            case 12: {
                listener.aboutToInsert(event);
                break;
            }
            case 13: {
                listener.aboutToUpdate(event);
                break;
            }
            case 14: {
                listener.aboutToDelete(event);
                break;
            }
            case 15: {
                listener.prePersist(event);
                break;
            }
            case 16: {
                listener.preRemove(event);
                break;
            }
            case 17: {
                listener.preUpdateWithChanges(event);
                break;
            }
            default: {
                throw DescriptorException.invalidDescriptorEventCode(event, this.getDescriptor());
            }
        }
    }

    public void notifyListeners(DescriptorEvent event) {
        if (this.hasAnyListeners()) {
            int index = 0;
            while (index < this.getEventListeners().size()) {
                DescriptorEventListener listener = this.getEventListeners().get(index);
                this.notifyListener(listener, event);
                ++index;
            }
        }
        if (this.getDescriptor().isChildDescriptor()) {
            this.getDescriptor().getInheritancePolicy().getParentDescriptor().getEventManager().notifyListeners(event);
        }
    }

    public void remoteInitialization(AbstractSession session) {
        this.eventMethods = DescriptorEventManager.newAtomicReferenceArray(18);
        this.initialize(session);
    }

    public void removeListener(DescriptorEventListener listener) {
        this.getEventListeners().remove(listener);
    }

    public void setAboutToDeleteSelector(String aboutToDeleteSelector) {
        this.getEventSelectors().set(14, aboutToDeleteSelector);
    }

    public void setAboutToInsertSelector(String aboutToInsertSelector) {
        this.getEventSelectors().set(12, aboutToInsertSelector);
    }

    public void setAboutToUpdateSelector(String aboutToUpdateSelector) {
        this.getEventSelectors().set(13, aboutToUpdateSelector);
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setEntityEventListener(DescriptorEventListener listener) {
        this.entityEventListener = listener;
    }

    protected void setEventListeners(List<DescriptorEventListener> eventListeners) {
        this.eventListeners = eventListeners instanceof CopyOnWriteArrayList ? eventListeners : new CopyOnWriteArrayList<DescriptorEventListener>(eventListeners);
    }

    protected void setEventMethods(AtomicReferenceArray<Method> eventMethods) {
        this.eventMethods = eventMethods;
    }

    protected void setEventSelectors(AtomicReferenceArray<String> eventSelectors) {
        this.eventSelectors = eventSelectors;
    }

    public void setExcludeDefaultListeners(boolean excludeDefaultListeners) {
        this.excludeDefaultListeners = excludeDefaultListeners;
    }

    public void setExcludeSuperclassListeners(boolean excludeSuperclassListeners) {
        this.excludeSuperclassListeners = excludeSuperclassListeners;
    }

    protected void setHasAnyEventListeners(boolean hasAnyEventListeners) {
        this.hasAnyEventListeners = hasAnyEventListeners;
    }

    public void setPostBuildSelector(String postBuildSelector) {
        this.getEventSelectors().set(8, postBuildSelector);
    }

    public void setPostCloneSelector(String postCloneSelector) {
        this.getEventSelectors().set(10, postCloneSelector);
    }

    public void setPostDeleteSelector(String postDeleteSelector) {
        this.getEventSelectors().set(3, postDeleteSelector);
    }

    public void setPostInsertSelector(String postInsertSelector) {
        this.getEventSelectors().set(5, postInsertSelector);
    }

    public void setPostMergeSelector(String postMergeSelector) {
        this.getEventSelectors().set(11, postMergeSelector);
    }

    public void setPostRefreshSelector(String postRefreshSelector) {
        this.getEventSelectors().set(9, postRefreshSelector);
    }

    public void setPostUpdateSelector(String postUpdateSelector) {
        this.getEventSelectors().set(7, postUpdateSelector);
    }

    public void setPostWriteSelector(String postWriteSelector) {
        this.getEventSelectors().set(1, postWriteSelector);
    }

    public void setPreDeleteSelector(String preDeleteSelector) {
        this.getEventSelectors().set(2, preDeleteSelector);
    }

    public void setPreInsertSelector(String preInsertSelector) {
        this.getEventSelectors().set(4, preInsertSelector);
    }

    public void setPrePersistSelector(String prePersistSelector) {
        this.getEventSelectors().set(15, prePersistSelector);
    }

    public void setPreRemoveSelector(String preRemoveSelector) {
        this.getEventSelectors().set(16, preRemoveSelector);
    }

    public void setPreUpdateSelector(String preUpdateSelector) {
        this.getEventSelectors().set(6, preUpdateSelector);
    }

    public void setPreWriteSelector(String preWriteSelector) {
        this.getEventSelectors().set(0, preWriteSelector);
    }

    private static <T> AtomicReferenceArray<T> newAtomicReferenceArray(int length) {
        AtomicReferenceArray<Object> array = new AtomicReferenceArray<Object>(length);
        int index = 0;
        while (index < length) {
            array.set(index++, null);
        }
        return array;
    }

    private static <T> AtomicReferenceArray<T> newAtomicReferenceArray(AtomicReferenceArray<T> src) {
        int length = src.length();
        AtomicReferenceArray<T> array = new AtomicReferenceArray<T>(length);
        int index = 0;
        while (index < length) {
            array.set(index, src.get(index++));
        }
        return array;
    }
}

