/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;

public class ColExcludedChecker {
    private final Set<ColumnDesc> excludedCols = Sets.newHashSet();
    private final Set<String> excludedColNames = Sets.newHashSet();
    private final Map<String, TblColRef> colIdentityMap = Maps.newHashMap();

    public ColExcludedChecker(KylinConfig config, String project, NDataModel model) {
        ProjectInstance prjInstance = NProjectManager.getInstance(config).getProject(project);
        if (!prjInstance.getConfig().isTableExclusionEnabled()) {
            return;
        }
        NTableMetadataManager tableMgr = NTableMetadataManager.getInstance(config, project);
        List<TableDesc> allTables = tableMgr.listAllTables();
        HashMap identityToRefMap = Maps.newHashMap();
        if (model != null && !model.isBroken()) {
            for (JoinTableDesc joinTableDesc : model.getJoinTables()) {
                TableRef tableRef = joinTableDesc.getTableRef();
                identityToRefMap.put(tableRef.getTableIdentity(), tableRef);
            }
        }
        Set desiredTables = allTables.stream().filter(table -> model == null || identityToRefMap.containsKey(table.getIdentity())).collect(Collectors.toSet());
        for (TableDesc table2 : desiredTables) {
            String factTable;
            TableExtDesc tableExt = tableMgr.getTableExtIfExists(table2);
            String string = factTable = model == null ? "" : model.getRootFactTableName();
            if (StringUtils.equalsIgnoreCase((CharSequence)table2.getIdentity(), (CharSequence)factTable) || tableExt == null) continue;
            Set<String> excludedSet = tableExt.getExcludedColumns();
            List list = Arrays.stream(table2.getColumns()).filter(Objects::nonNull).filter(col -> tableExt.isExcluded() || excludedSet.contains(col.getName())).collect(Collectors.toList());
            this.excludedCols.addAll(list);
        }
        this.collectExcludedComputedColumns(config, project, model);
    }

    private void collectExcludedComputedColumns(KylinConfig config, String project, NDataModel originModel) {
        if (originModel == null || originModel.isBroken()) {
            return;
        }
        NDataModel model = originModel;
        if (originModel.getAllTables().isEmpty() || originModel.getEffectiveCols() == null) {
            model = NDataModelManager.getInstance(config, project).copyForWrite(originModel);
            model.init(config, project, Lists.newArrayList());
        }
        model.getAllTables().stream().filter(Objects::nonNull).flatMap(tableRef -> tableRef.getColumns().stream()).filter(tblColRef -> this.excludedCols.contains(tblColRef.getColumnDesc())).map(TblColRef::getBackTickIdentity).forEach(this.excludedColNames::add);
        model.getEffectiveCols().forEach((id, colRef) -> this.colIdentityMap.put(colRef.getIdentity(), (TblColRef)colRef));
        model.getComputedColumnDescs().forEach(cc -> {
            TblColRef tblColRef = this.colIdentityMap.get(cc.getFullName());
            if (tblColRef == null) {
                return;
            }
            ColumnDesc columnDesc = tblColRef.getColumnDesc();
            if (this.isExcludedCC(cc.getInnerExpression())) {
                this.excludedCols.add(columnDesc);
                this.excludedColNames.add(columnDesc.getBackTickIdentity());
            }
        });
    }

    public Set<String> filterRelatedExcludedColumn(NDataModel model) {
        String fact = model == null ? "" : model.getRootFactTableName();
        return this.getExcludedCols().stream().filter(col -> !col.getTable().getIdentity().equalsIgnoreCase(fact)).map(ColumnDesc::getIdentity).collect(Collectors.toSet());
    }

    public boolean anyExcludedColMatch(Collection<TblColRef> tblColRefs) {
        return tblColRefs.stream().anyMatch(this::isExcludedCol);
    }

    public boolean isExcludedCol(@NonNull TblColRef tblColRef) {
        if (tblColRef == null) {
            throw new NullPointerException("tblColRef is marked @NonNull but is null");
        }
        return this.excludedCols.contains(tblColRef.getColumnDesc()) || this.isExcludedCC(tblColRef);
    }

    private boolean isExcludedCC(@NonNull TblColRef tblColRef) {
        boolean value;
        if (tblColRef == null) {
            throw new NullPointerException("tblColRef is marked @NonNull but is null");
        }
        ColumnDesc columnDesc = tblColRef.getColumnDesc();
        if (columnDesc != null && columnDesc.isComputedColumn() && (value = this.isExcludedCC(columnDesc.getComputedColumnExpr()))) {
            return true;
        }
        List<TblColRef> operands = tblColRef.getOperands();
        if (operands == null) {
            return false;
        }
        for (TblColRef colRef : operands) {
            if (!this.isExcludedCol(colRef)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedCC(ComputedColumnDesc cc) {
        return this.isExcludedCC(cc.getInnerExpression());
    }

    public boolean isExcludedCC(String innerExpression) {
        String[] splits;
        if (StringUtils.isBlank((CharSequence)innerExpression)) {
            return false;
        }
        for (String split : splits = innerExpression.split("\\s")) {
            int begin = split.indexOf(96);
            int end = split.lastIndexOf(96);
            if (begin == -1 || !this.excludedColNames.contains(split.substring(begin, end + 1))) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedMeasure(@NonNull FunctionDesc functionDesc) {
        if (functionDesc == null) {
            throw new NullPointerException("functionDesc is marked @NonNull but is null");
        }
        List<TblColRef> colRefs = functionDesc.getColRefs();
        if (CollectionUtils.isEmpty(colRefs)) {
            return false;
        }
        for (TblColRef colRef : colRefs) {
            if (!this.isExcludedCol(colRef)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public ColExcludedChecker() {
    }

    @Generated
    public Set<ColumnDesc> getExcludedCols() {
        return this.excludedCols;
    }

    @Generated
    public Set<String> getExcludedColNames() {
        return this.excludedColNames;
    }
}

