/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.hystrix.NCircuitBreaker;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.Manager;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.CcModelRelationDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnManager;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableModelRelationDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.exception.ModelBrokenException;
import org.apache.kylin.metadata.project.NProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDataModelManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NDataModelManager.class);
    private KylinConfig config;
    private String project;
    private CachedCrudAssist<NDataModel> crud;

    public static NDataModelManager getInstance(KylinConfig config, String project) {
        return (NDataModelManager)config.getManager(project, NDataModelManager.class);
    }

    static NDataModelManager newInstance(KylinConfig conf, String project) {
        try {
            String cls = NDataModelManager.class.getName();
            Class clz = ClassUtil.forName((String)cls, NDataModelManager.class);
            return (NDataModelManager)clz.getConstructor(KylinConfig.class, String.class).newInstance(conf, project);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to init DataModelManager from " + conf, e);
        }
    }

    public NDataModelManager(KylinConfig config, String project) {
        this.init(config, project);
    }

    protected void init(KylinConfig cfg, final String project) {
        this.config = cfg;
        this.project = project;
        this.crud = new CachedCrudAssist<NDataModel>(this.getStore(), MetadataType.MODEL, project, NDataModel.class){

            @Override
            protected NDataModel initEntityAfterReload(NDataModel model, String resourceName) {
                if (model.getBrokenReason() != NDataModel.BrokenReason.NULL) {
                    throw new ModelBrokenException();
                }
                if (!model.getComputedColumnDescs().isEmpty()) {
                    model.init(NDataModelManager.this.config, project, this.listAllValidCache().stream().filter(m -> !m.isBroken()).collect(Collectors.toList()));
                } else {
                    model.init(NDataModelManager.this.config, project, Lists.newArrayList());
                }
                NDataModelManager.this.postModelRepairEvent(model);
                return model;
            }

            @Override
            protected NDataModel initBrokenEntity(NDataModel entity, String resourceName) {
                NDataModel model = super.initBrokenEntity(entity, resourceName);
                model.setProject(project);
                model.setConfig(NDataModelManager.this.config);
                if (entity != null) {
                    model.setHandledAfterBroken(entity.isHandledAfterBroken());
                    model.setAlias(entity.getAlias());
                    model.setRootFactTableName(entity.getRootFactTableName());
                    model.setJoinTables(entity.getJoinTables());
                    model.setDependencies(model.calcDependencies());
                    model.setModelType(entity.getModelType());
                    model.setLastModified(entity.getLastModified());
                    NDataModelManager.this.postModelBrokenEvent(entity);
                }
                return model;
            }
        };
    }

    private void postModelBrokenEvent(NDataModel model) {
        if (!model.isHandledAfterBroken()) {
            if (UnitOfWork.isAlreadyInTransaction()) {
                UnitOfWork.get().doAfterUnit(() -> EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new NDataModel.ModelBrokenEvent(this.project, model.getUuid())));
            } else {
                EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new NDataModel.ModelBrokenEvent(this.project, model.getUuid()));
            }
        }
    }

    private void postModelRepairEvent(NDataModel model) {
        if (model.isHandledAfterBroken()) {
            if (UnitOfWork.isAlreadyInTransaction()) {
                UnitOfWork.get().doAfterUnit(() -> EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new NDataModel.ModelRepairEvent(this.project, model.getUuid())));
            } else {
                EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new NDataModel.ModelRepairEvent(this.project, model.getUuid()));
            }
        }
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public Serializer<NDataModel> getDataModelSerializer() {
        return this.crud.getSerializer();
    }

    public NDataModel getDataModelDesc(String modelId) {
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return null;
        }
        return this.crud.get(modelId);
    }

    public NDataModel getDataModelDescWithoutInit(String modelId) {
        try {
            RawResource resource = ResourceStore.getKylinMetaStore((KylinConfig)this.config).getResource(this.getDataModelDesc(modelId).getResourcePath());
            NDataModel modelDesc = (NDataModel)((Object)JsonUtil.readValue((byte[])resource.getByteSource().read(), NDataModel.class));
            modelDesc.setMvcc(resource.getMvcc());
            modelDesc.setProject(this.project);
            return modelDesc;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isModelBroken(String modelId) {
        NDataflowManager dataflowManager = NDataflowManager.getInstance(this.config, this.project);
        NDataflow dataflow = dataflowManager.getDataflow(modelId);
        return dataflow == null || dataflow.checkBrokenWithRelatedInfo();
    }

    public NDataModel getDataModelDescByAlias(String alias) {
        RawResourceFilter filter = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE, (String)"alias", (Object)alias);
        return this.crud.listByFilter(filter).stream().findFirst().orElse(null);
    }

    public List<String> getModelNamesByFuzzyName(String fuzzyName) {
        RawResourceFilter filter = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE, (String)"alias", (Object)fuzzyName);
        return this.crud.listByFilter(filter).stream().map(NDataModel::getAlias).collect(Collectors.toList());
    }

    public NDataModel dropModel(NDataModel model) {
        this.crud.delete(model);
        this.dropRelatedCc(model);
        return model;
    }

    private void dropRelatedCc(NDataModel model) {
        Manager<CcModelRelationDesc> relationManager = Manager.getInstance(this.config, this.project, CcModelRelationDesc.class);
        List<CcModelRelationDesc> items = relationManager.listByFilter(RawResourceFilter.equalFilter((String)"modelUuid", (String)model.getUuid()));
        items.forEach(relationManager::delete);
        Set<String> ccUuids = items.stream().map(CcModelRelationDesc::getCcUuid).collect(Collectors.toSet());
        relationManager.listAll().stream().map(CcModelRelationDesc::getCcUuid).forEach(ccUuids::remove);
        ComputedColumnManager ccManager = (ComputedColumnManager)this.config.getManager(this.project, ComputedColumnManager.class);
        ccUuids.forEach(cc -> ccManager.get((String)cc).ifPresent(ccManager::delete));
    }

    public NDataModel dropModel(String id) {
        NDataModel model = this.getDataModelDesc(id);
        if (model == null) {
            return null;
        }
        return this.dropModel(model);
    }

    public Set<String> listAllModelAlias() {
        return this.listAllModels().stream().map(NDataModel::getAlias).collect(Collectors.toSet());
    }

    public Set<String> listAllModelIds() {
        return this.listAllModels().stream().map(RootPersistentEntity::getId).collect(Collectors.toSet());
    }

    public List<NDataModel> listAllModels() {
        return this.crud.listAll();
    }

    private List<NDataModel> readAllModelsFromSystem(String project) {
        KylinConfig systemKylinConfig = KylinConfig.readSystemKylinConfig();
        Preconditions.checkNotNull((Object)systemKylinConfig, (Object)"System KylinConfig is null.");
        NDataModelManager instance = NDataModelManager.getInstance(systemKylinConfig, project);
        return instance.listAllModels();
    }

    public void checkDuplicateModel(NDataModel model) {
        List<NDataModel> allModels = this.readAllModelsFromSystem(model.getProject());
        for (NDataModel existingModel : allModels) {
            if (!existingModel.getAlias().equalsIgnoreCase(model.getAlias()) && !existingModel.getUuid().equals(model.getUuid())) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, MsgPicker.getMsg().getDuplicateModelName(), model.getAlias()));
        }
    }

    public NDataModel createDataModelDesc(NDataModel model, String owner) {
        NDataModel copy = this.copyForWrite(model);
        this.checkDuplicateModel(model);
        List<NDataModel> allModels = this.listAllModels();
        NCircuitBreaker.verifyModelCreation((int)allModels.size());
        copy.setOwner(owner);
        if (model.getStorageTypeValue() == 0) {
            copy.setStorageType(NProjectManager.getProjectConfig(this.project).getDefaultStorageType());
        }
        model = this.saveModel(copy);
        return model;
    }

    public Set<Long> addPartitionsIfAbsent(NDataModel model, List<String[]> partitionValues) {
        Preconditions.checkState((boolean)model.isMultiPartitionModel());
        HashSet partitionIds = Sets.newHashSet();
        NDataModel copy = this.copyForWrite(model);
        AtomicLong maxPartitionId = new AtomicLong(copy.getMultiPartitionDesc().getMaxPartitionID());
        partitionValues.forEach(value -> {
            MultiPartitionDesc.PartitionInfo partition = copy.getMultiPartitionDesc().getPartitionByValue((String[])value);
            if (partition != null) {
                partitionIds.add(partition.getId());
            } else if ((value = this.wrapValue((String[])value)).length != 0) {
                MultiPartitionDesc.PartitionInfo toAddPartition = new MultiPartitionDesc.PartitionInfo(maxPartitionId.incrementAndGet(), this.wrapValue((String[])value));
                copy.getMultiPartitionDesc().getPartitions().add(toAddPartition);
                partitionIds.add(toAddPartition.getId());
            }
        });
        copy.getMultiPartitionDesc().setMaxPartitionID(maxPartitionId.get());
        this.crud.save(copy);
        return partitionIds;
    }

    private String[] wrapValue(String[] value) {
        return (String[])Arrays.stream(value).map(String::trim).filter(StringUtils::isNotBlank).toArray(String[]::new);
    }

    public NDataModel updateDataModel(String modelId, NDataModelUpdater updater) {
        NDataModel cached = this.getDataModelDesc(modelId);
        if (cached == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelId});
        }
        if (cached.isBroken()) {
            cached = this.getDataModelDescWithoutInit(modelId);
        }
        NDataModel copy = this.copyForWrite(cached);
        updater.modify(copy);
        return this.saveModel(copy);
    }

    @Deprecated
    public NDataModel updateDataModelDesc(NDataModel desc) {
        String name = desc.getUuid();
        if (!this.crud.contains(desc.getUuid())) {
            throw new IllegalArgumentException("Model '" + name + "' does not exist.");
        }
        desc.init(this.config, this.project, this.getCCRelatedModels(desc));
        return this.updateDataModel(desc.getUuid(), arg_0 -> ((NDataModel)desc).copyPropertiesTo(arg_0));
    }

    public NDataModel updateDataBrokenModelDesc(NDataModel desc) {
        return this.crud.save(desc);
    }

    public void reloadAll() {
        this.crud.reloadAll();
    }

    private NDataModel saveModel(NDataModel model) {
        model.init(this.config, this.project, this.getCCRelatedModels(model));
        this.updateCcAndRelations(model);
        this.updateTableModelRelations(model);
        this.crud.save(model);
        return model;
    }

    private void updateCcAndRelations(NDataModel model) {
        ComputedColumnManager ccManager = (ComputedColumnManager)this.config.getManager(this.project, ComputedColumnManager.class);
        Manager<CcModelRelationDesc> relationManager = Manager.getInstance(this.config, this.project, CcModelRelationDesc.class);
        List<ComputedColumnDesc> newCC = model.getComputedColumnDescs().stream().map(cc -> ccManager.saveCCWithCheck(model, (ComputedColumnDesc)cc)).collect(Collectors.toList());
        model.setComputedColumnUuids(newCC.stream().map(RootPersistentEntity::getUuid).collect(Collectors.toList()));
        model.setComputedColumnDescs(newCC);
        List<CcModelRelationDesc> oldRelations = relationManager.listByFilter(RawResourceFilter.equalFilter((String)"modelUuid", (String)model.getUuid()));
        List oldUuids = oldRelations.stream().map(CcModelRelationDesc::getCcUuid).collect(Collectors.toList());
        oldRelations.stream().filter(relation -> !model.getComputedColumnUuids().contains(relation.getCcUuid())).forEach(relationManager::delete);
        model.getComputedColumnUuids().stream().filter(uuid -> !oldUuids.contains(uuid)).forEach(uuid -> relationManager.createAS(new CcModelRelationDesc((String)uuid, model.getUuid())));
    }

    private void updateTableModelRelations(NDataModel model) {
        Manager<TableModelRelationDesc> relationManager = Manager.getInstance(this.config, this.project, TableModelRelationDesc.class);
        List<TableModelRelationDesc> oldRelations = relationManager.listByFilter(RawResourceFilter.equalFilter((String)"modelUuid", (String)model.getUuid()));
        List oldIdentities = oldRelations.stream().map(TableModelRelationDesc::getTableIdentity).collect(Collectors.toList());
        Set finalIdentities = model.getAllTables().stream().map(TableRef::getTableIdentity).collect(Collectors.toSet());
        oldRelations.stream().filter(relation -> !finalIdentities.contains(relation.getTableIdentity())).forEach(relationManager::delete);
        finalIdentities.stream().filter(identity -> !oldIdentities.contains(identity)).forEach(identity -> relationManager.createAS(new TableModelRelationDesc((String)identity, model.getUuid())));
    }

    public NDataModel copyForWrite(NDataModel nDataModel) {
        return this.crud.copyForWrite(nDataModel);
    }

    public NDataModel copyBySerialization(NDataModel dataModel) {
        return this.crud.copyBySerialization(dataModel);
    }

    public String getModelDisplayName(String modelId) {
        NDataModel dataModelDesc = this.getDataModelDesc(modelId);
        return dataModelDesc == null ? "NotFoundModel(" + modelId + ")" : dataModelDesc.toString();
    }

    public static Map<String, TableDesc> getRelatedTables(NDataModel dataModel, String project) {
        HashMap tableMapping = Maps.newHashMap();
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance(dataModel.getConfig(), project);
        if (dataModel.getRootFactTableName() != null) {
            tableMapping.put(dataModel.getRootFactTableName(), tableManager.getTableDesc(dataModel.getRootFactTableName()));
        }
        if (dataModel.getJoinTables() != null) {
            dataModel.getJoinTables().forEach(joinTable -> tableMapping.put(joinTable.getTable(), tableManager.getTableDesc(joinTable.getTable())));
        }
        return tableMapping;
    }

    public List<NDataModel> getCCRelatedModels(NDataModel model) {
        if (model.getComputedColumnDescs().isEmpty()) {
            return Lists.newArrayList();
        }
        NDataflowManager manager = NDataflowManager.getInstance(KylinConfig.readSystemKylinConfig(), this.project);
        NDataflowManager innerManager = NDataflowManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project);
        return manager.listAllDataflows(true).stream().filter(df -> df.checkBrokenWithRelatedInfo() || !df.getModel().getComputedColumnDescs().isEmpty()).map(df -> innerManager.getDataflow(df.getId())).filter(df -> df != null && !df.checkBrokenWithRelatedInfo()).map(NDataflow::getModel).collect(Collectors.toList());
    }

    private void lockModelsUnderProject() {
        this.getStore().batchLock(MetadataType.MODEL, RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE, (String)"project", (Object)this.project));
    }

    public static interface NDataModelUpdater {
        public void modify(NDataModel var1);
    }
}

