/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.Lists;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DataParserInfo
extends RootPersistentEntity
implements Serializable {
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="class_name")
    private String className;
    @JsonProperty(value="jar_name")
    private String jarName;
    @JsonProperty(value="streaming_tables")
    private List<String> streamingTables = Lists.newCopyOnWriteArrayList();

    public DataParserInfo() {
    }

    public DataParserInfo(String project, String className, String jarName) {
        this.project = project;
        this.className = className;
        this.jarName = jarName;
    }

    public String resourceName() {
        return DataParserInfo.generateResourcePath(this.project, this.className);
    }

    public static String generateResourcePath(String project, String className) {
        return project + "." + className;
    }

    public MetadataType resourceType() {
        return MetadataType.DATA_PARSER;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public String getJarName() {
        return this.jarName;
    }

    @Generated
    public List<String> getStreamingTables() {
        return this.streamingTables;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setClassName(String className) {
        this.className = className;
    }

    @Generated
    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    @Generated
    public void setStreamingTables(List<String> streamingTables) {
        this.streamingTables = streamingTables;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataParserInfo)) {
            return false;
        }
        DataParserInfo other = (DataParserInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$jarName = this.getJarName();
        String other$jarName = other.getJarName();
        if (this$jarName == null ? other$jarName != null : !this$jarName.equals(other$jarName)) {
            return false;
        }
        List<String> this$streamingTables = this.getStreamingTables();
        List<String> other$streamingTables = other.getStreamingTables();
        return !(this$streamingTables == null ? other$streamingTables != null : !((Object)this$streamingTables).equals(other$streamingTables));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataParserInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $jarName = this.getJarName();
        result = result * 59 + ($jarName == null ? 43 : $jarName.hashCode());
        List<String> $streamingTables = this.getStreamingTables();
        result = result * 59 + ($streamingTables == null ? 43 : ((Object)$streamingTables).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataParserInfo(project=" + this.getProject() + ", className=" + this.getClassName() + ", jarName=" + this.getJarName() + ", streamingTables=" + this.getStreamingTables() + ")";
    }
}

