/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.common.ExecutableUtil;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutOptimizeJobUtil
extends ExecutableUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LayoutOptimizeJobUtil.class);

    @Override
    public void computeLayout(JobParam jobParam) {
        IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getIndexPlan(jobParam.getModel());
        LinkedHashSet toBeProcessedLayouts = Sets.newLinkedHashSet();
        Set<Long> targetLayouts = jobParam.getTargetLayouts();
        if (targetLayouts.isEmpty()) {
            toBeProcessedLayouts.addAll(indexPlan.getAllLayouts());
        } else {
            HashSet target = Sets.newHashSet(jobParam.getTargetLayouts());
            indexPlan.getAllLayouts().forEach(layout -> {
                if (target.contains(layout.getId())) {
                    toBeProcessedLayouts.add(layout);
                }
            });
        }
        jobParam.setProcessLayouts(this.filterTobeDelete(toBeProcessedLayouts));
        this.checkLayoutsNotEmpty(jobParam);
    }

    static {
        LayoutOptimizeJobUtil.registerImplementation(JobTypeEnum.LAYOUT_DATA_OPTIMIZE, new LayoutOptimizeJobUtil());
    }
}

