/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import org.mybatis.dynamic.sql.insert.BatchInsertModel;
import org.mybatis.dynamic.sql.insert.render.BatchInsert;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueCollector;
import org.mybatis.dynamic.sql.insert.render.InsertRenderingUtilities;
import org.mybatis.dynamic.sql.insert.render.MultiRowValuePhraseVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;

public class BatchInsertRenderer<T> {
    private final BatchInsertModel<T> model;
    private final RenderingStrategy renderingStrategy;

    private BatchInsertRenderer(Builder<T> builder) {
        this.model = Objects.requireNonNull(((Builder)builder).model);
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
    }

    public BatchInsert<T> render() {
        MultiRowValuePhraseVisitor visitor = new MultiRowValuePhraseVisitor(this.renderingStrategy, "row");
        FieldAndValueCollector collector = this.model.mapColumnMappings(m -> m.accept(visitor)).collect(FieldAndValueCollector.collect());
        String insertStatement = InsertRenderingUtilities.calculateInsertStatement(this.model.table(), collector);
        return BatchInsert.withRecords(this.model.records()).withInsertStatement(insertStatement).build();
    }

    public static <T> Builder<T> withBatchInsertModel(BatchInsertModel<T> model) {
        return new Builder<T>().withBatchInsertModel(model);
    }

    public static class Builder<T> {
        private BatchInsertModel<T> model;
        private RenderingStrategy renderingStrategy;

        public Builder<T> withBatchInsertModel(BatchInsertModel<T> model) {
            this.model = model;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public BatchInsertRenderer<T> build() {
            return new BatchInsertRenderer(this);
        }
    }
}

