/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Function;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.JoinType;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Predicate2;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.ConstantUntypedNull;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.runtime.SortedMultiMap;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumUtils {
    static final boolean BRIDGE_METHODS = true;
    static final List<ParameterExpression> NO_PARAMS = ImmutableList.of();
    static final List<Expression> NO_EXPRS = ImmutableList.of();
    public static final List<String> LEFT_RIGHT = ImmutableList.of((Object)"left", (Object)"right");

    private EnumUtils() {
    }

    public static MethodDeclaration overridingMethodDecl(Method method, Iterable<ParameterExpression> parameters, BlockStatement body) {
        return Expressions.methodDecl((int)(method.getModifiers() & 0xFFFFFBFF), method.getReturnType(), (String)method.getName(), parameters, (BlockStatement)body);
    }

    static Type javaClass(JavaTypeFactory typeFactory, RelDataType type) {
        Type clazz = typeFactory.getJavaClass(type);
        return clazz instanceof Class ? clazz : Object[].class;
    }

    static List<Type> fieldTypes(final JavaTypeFactory typeFactory, final List<? extends RelDataType> inputTypes) {
        return new AbstractList<Type>(){

            @Override
            public Type get(int index) {
                return EnumUtils.javaClass(typeFactory, (RelDataType)inputTypes.get(index));
            }

            @Override
            public int size() {
                return inputTypes.size();
            }
        };
    }

    static List<RelDataType> fieldRowTypes(RelDataType inputRowType, final @Nullable List<? extends RexNode> extraInputs, final List<Integer> argList) {
        final List<RelDataTypeField> inputFields = inputRowType.getFieldList();
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                int arg = (Integer)argList.get(index);
                return arg < inputFields.size() ? ((RelDataTypeField)inputFields.get(arg)).getType() : ((RexNode)Objects.requireNonNull(extraInputs, "extraInputs").get(arg - inputFields.size())).getType();
            }

            @Override
            public int size() {
                return argList.size();
            }
        };
    }

    static Expression joinSelector(JoinRelType joinType, PhysType physType, List<PhysType> inputPhysTypes) {
        ArrayList<ParameterExpression> parameters = new ArrayList<ParameterExpression>();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int outputFieldCount = physType.getRowType().getFieldCount();
        for (Ord ord : Ord.zip(inputPhysTypes)) {
            PhysType inputPhysType = ((PhysType)ord.e).makeNullable(joinType.generatesNullsOn(ord.i));
            ParameterExpression parameter = Expressions.parameter((Type)Primitive.box((Type)inputPhysType.getJavaRowType()), (String)LEFT_RIGHT.get(ord.i));
            parameters.add(parameter);
            if (expressions.size() == outputFieldCount) break;
            int fieldCount = inputPhysType.getRowType().getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                Expression expression = inputPhysType.fieldReference((Expression)parameter, i, physType.getJavaFieldType(expressions.size()));
                if (joinType.generatesNullsOn(ord.i)) {
                    expression = Expressions.condition((Expression)Expressions.equal((Expression)parameter, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)expression);
                }
                expressions.add(expression);
            }
        }
        return Expressions.lambda(Function2.class, (Expression)physType.record(expressions), parameters);
    }

    static Expression toInternal(Expression operand, @Nullable Type targetType) {
        return EnumUtils.toInternal(operand, operand.getType(), targetType);
    }

    private static Expression toInternal(Expression operand, Type fromType, @Nullable Type targetType) {
        if (fromType == Date.class) {
            if (targetType == Integer.TYPE) {
                return Expressions.call((Method)BuiltInMethod.DATE_TO_INT.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Integer.class) {
                return Expressions.call((Method)BuiltInMethod.DATE_TO_INT_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        } else if (fromType == Time.class) {
            if (targetType == Integer.TYPE) {
                return Expressions.call((Method)BuiltInMethod.TIME_TO_INT.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Integer.class) {
                return Expressions.call((Method)BuiltInMethod.TIME_TO_INT_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        } else if (fromType == Timestamp.class) {
            if (targetType == Long.TYPE) {
                return Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_LONG.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Long.class) {
                return Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        }
        return operand;
    }

    private static Expression fromInternal(Expression operand, Type targetType) {
        return EnumUtils.fromInternal(operand, operand.getType(), targetType);
    }

    private static Expression fromInternal(Expression operand, Type fromType, Type targetType) {
        if (operand == ConstantUntypedNull.INSTANCE) {
            return operand;
        }
        if (!(operand.getType() instanceof Class)) {
            return operand;
        }
        if (Types.isAssignableFrom((Type)targetType, (Type)fromType)) {
            return operand;
        }
        if (targetType == Date.class) {
            if (EnumUtils.isA(fromType, Primitive.INT)) {
                return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_DATE.method, (Expression[])new Expression[]{operand});
            }
        } else if (targetType == Time.class) {
            if (EnumUtils.isA(fromType, Primitive.INT)) {
                return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_TIME.method, (Expression[])new Expression[]{operand});
            }
        } else if (targetType == Timestamp.class && EnumUtils.isA(fromType, Primitive.LONG)) {
            return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand});
        }
        if (Primitive.is((Type)operand.type) && Primitive.isBox((Type)targetType)) {
            return Expressions.convert_((Expression)operand, (Type)Primitive.unbox((Type)targetType));
        }
        return operand;
    }

    static List<Expression> fromInternal(Class<?>[] targetTypes, List<Expression> expressions) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (targetTypes.length == expressions.size()) {
            for (int i = 0; i < expressions.size(); ++i) {
                list.add(EnumUtils.fromInternal(expressions.get(i), targetTypes[i]));
            }
        } else {
            int j = 0;
            for (int i = 0; i < expressions.size(); ++i) {
                Class<?> type;
                if (!targetTypes[j].isArray()) {
                    type = targetTypes[j];
                    ++j;
                } else {
                    type = targetTypes[j].getComponentType();
                }
                list.add(EnumUtils.fromInternal(expressions.get(i), type));
            }
        }
        return list;
    }

    static Type fromInternal(Type type) {
        if (type == Date.class || type == Time.class) {
            return Integer.TYPE;
        }
        if (type == Timestamp.class) {
            return Long.TYPE;
        }
        return type;
    }

    private static @Nullable Type toInternal(RelDataType type) {
        return EnumUtils.toInternal(type, false);
    }

    static @Nullable Type toInternal(RelDataType type, boolean forceNotNull) {
        switch (type.getSqlTypeName()) {
            case DATE: 
            case TIME: {
                return type.isNullable() && !forceNotNull ? Integer.class : Integer.TYPE;
            }
            case TIMESTAMP: {
                return type.isNullable() && !forceNotNull ? Long.class : Long.TYPE;
            }
        }
        return null;
    }

    static List<@Nullable Type> internalTypes(List<? extends RexNode> operandList) {
        return Util.transform(operandList, node -> EnumUtils.toInternal(node.getType()));
    }

    public static Expression convert(Expression operand, Type toType) {
        Type fromType = operand.getType();
        return EnumUtils.convert(operand, fromType, toType);
    }

    public static Expression convert(Expression operand, Type fromType, Type toType) {
        Expression originTypedOperand;
        Expression internalTypedOperand;
        boolean fromNumber;
        if (!Types.needTypeCast((Type)fromType, (Type)toType)) {
            return operand;
        }
        Primitive toPrimitive = Primitive.of((Type)toType);
        Primitive toBox = Primitive.ofBox((Type)toType);
        Primitive fromBox = Primitive.ofBox((Type)fromType);
        Primitive fromPrimitive = Primitive.of((Type)fromType);
        boolean bl = fromNumber = fromType instanceof Class && Number.class.isAssignableFrom((Class)fromType);
        if (fromType == String.class) {
            if (toPrimitive != null) {
                switch (toPrimitive) {
                    case CHAR: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toPrimitive.getPrimitiveName())), (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toPrimitive.getBoxClass(), (String)("parse" + SqlFunctions.initcap(toPrimitive.getPrimitiveName())), (Expression[])new Expression[]{operand});
            }
            if (toBox != null) {
                switch (toBox) {
                    case VOID: {
                        return Expressions.constant(null);
                    }
                    case CHAR: {
                        return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toBox.getPrimitiveName()) + "Boxed"), (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toBox.getBoxClass(), (String)"valueOf", (Expression[])new Expression[]{operand});
            }
        }
        if (toPrimitive != null) {
            if (fromPrimitive != null) {
                return Expressions.convert_((Expression)operand, (Type)toPrimitive.getPrimitiveClass());
            }
            if (fromNumber || fromBox == Primitive.CHAR) {
                return Expressions.unbox((Expression)operand, (Primitive)toPrimitive);
            }
            return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toPrimitive.getPrimitiveName())), (Expression[])new Expression[]{operand});
        }
        if (fromNumber && toBox != null) {
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.box((Expression)Expressions.unbox((Expression)operand, (Primitive)toBox), (Primitive)toBox));
        }
        if (fromPrimitive != null && toBox != null) {
            if (operand instanceof UnaryExpression) {
                Primitive origin;
                UnaryExpression una = (UnaryExpression)operand;
                if (una.nodeType == ExpressionType.Convert && Primitive.of((Type)una.getType()) == toBox && (origin = Primitive.of((Type)una.expression.type)) != null && toBox.assignableFrom(origin)) {
                    return Expressions.box((Expression)una.expression, (Primitive)toBox);
                }
            }
            if (fromType == toBox.primitiveClass) {
                return Expressions.box((Expression)operand, (Primitive)toBox);
            }
            return Expressions.box((Expression)Expressions.convert_((Expression)operand, (Type)toBox.getPrimitiveClass()), (Primitive)toBox);
        }
        if (EnumUtils.representAsInternalType(fromType) && operand != (internalTypedOperand = EnumUtils.toInternal(operand, fromType, toType))) {
            return internalTypedOperand;
        }
        if (EnumUtils.representAsInternalType(toType) && operand != (originTypedOperand = EnumUtils.fromInternal(operand, fromType, toType))) {
            return originTypedOperand;
        }
        if (toType == BigDecimal.class) {
            if (fromBox != null) {
                return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{Expressions.unbox((Expression)operand, (Primitive)fromBox)}));
            }
            if (fromPrimitive != null) {
                return Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{operand});
            }
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call(SqlFunctions.class, (String)"toBigDecimal", (Expression[])new Expression[]{operand}));
        }
        if (toType == String.class) {
            Expression result;
            if (fromPrimitive != null) {
                switch (fromPrimitive) {
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)fromPrimitive.getBoxClass(), (String)"toString", (Expression[])new Expression[]{operand});
            }
            if (fromType == BigDecimal.class) {
                return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call(SqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand}));
            }
            try {
                if (operand instanceof ConstantExpression) {
                    ConstantExpression ce = (ConstantExpression)operand;
                    if (ce.value == null) {
                        return Expressions.convert_((Expression)operand, (Type)toType);
                    }
                }
                result = Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call((Expression)operand, (String)"toString", (Expression[])new Expression[0]));
            }
            catch (RuntimeException e) {
                return Expressions.convert_((Expression)operand, (Type)toType);
            }
            return result;
        }
        return Expressions.convert_((Expression)operand, (Type)toType);
    }

    public static <T> @Nullable T evaluate(Object o, Class<T> clazz) {
        clazz = Primitive.box(clazz);
        BlockBuilder bb = new BlockBuilder();
        Expression expr = EnumUtils.convert((Expression)Expressions.constant((Object)o), clazz);
        bb.add((Statement)Expressions.return_(null, (Expression)expr));
        FunctionExpression convert = Expressions.lambda((BlockStatement)bb.toBlock(), (Iterable)ImmutableList.of());
        return clazz.cast(convert.compile().dynamicInvoke(new Object[0]));
    }

    private static boolean isA(Type fromType, Primitive primitive) {
        return Primitive.of((Type)fromType) == primitive || Primitive.ofBox((Type)fromType) == primitive;
    }

    private static boolean representAsInternalType(Type type) {
        return type == Date.class || type == Time.class || type == Timestamp.class;
    }

    static List<Expression> convertAssignableTypes(Class<?>[] targetTypes, List<Expression> arguments) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (targetTypes.length == arguments.size()) {
            for (int i = 0; i < arguments.size(); ++i) {
                list.add(EnumUtils.convertAssignableType(arguments.get(i), targetTypes[i]));
            }
        } else {
            int j = 0;
            for (Expression argument : arguments) {
                Class<?> type;
                if (!targetTypes[j].isArray()) {
                    type = targetTypes[j];
                    ++j;
                } else {
                    type = targetTypes[j].getComponentType();
                }
                list.add(EnumUtils.convertAssignableType(argument, type));
            }
        }
        return list;
    }

    private static Expression convertAssignableType(Expression argument, Type targetType) {
        if (targetType != BigDecimal.class) {
            return argument;
        }
        return EnumUtils.convert(argument, targetType);
    }

    public static MethodCallExpression call(@Nullable Expression targetExpression, Class clazz, String methodName, List<? extends Expression> arguments) {
        Object[] argumentTypes = Types.toClassArray(arguments);
        try {
            Method candidate = clazz.getMethod(methodName, (Class<?>[])argumentTypes);
            return Expressions.call((Expression)targetExpression, (Method)candidate, arguments);
        }
        catch (NoSuchMethodException e) {
            for (Method method : clazz.getMethods()) {
                Class[] parameterTypes;
                if (!method.getName().equals(methodName)) continue;
                boolean varArgs = method.isVarArgs();
                if (Types.allAssignable((boolean)varArgs, (Class[])(parameterTypes = method.getParameterTypes()), (Class[])argumentTypes)) {
                    return Expressions.call((Expression)targetExpression, (Method)method, arguments);
                }
                List<? extends Expression> typeMatchedArguments = EnumUtils.matchMethodParameterTypes(varArgs, parameterTypes, arguments);
                if (typeMatchedArguments == null) continue;
                return Expressions.call((Expression)targetExpression, (Method)method, typeMatchedArguments);
            }
            throw new RuntimeException("while resolving method '" + methodName + Arrays.toString(argumentTypes) + "' in class " + clazz, e);
        }
    }

    private static @Nullable List<? extends Expression> matchMethodParameterTypes(boolean varArgs, Class<?>[] parameterTypes, List<? extends Expression> arguments) {
        if (varArgs && arguments.size() < parameterTypes.length - 1 || !varArgs && arguments.size() != parameterTypes.length) {
            return null;
        }
        ArrayList<Expression> typeMatchedArguments = new ArrayList<Expression>();
        for (int i = 0; i < arguments.size(); ++i) {
            Class<?> parameterType = !varArgs || i < parameterTypes.length - 1 ? parameterTypes[i] : Object.class;
            Expression typeMatchedArgument = EnumUtils.matchMethodParameterType(arguments.get(i), parameterType);
            if (typeMatchedArgument == null) {
                return null;
            }
            typeMatchedArguments.add(typeMatchedArgument);
        }
        return typeMatchedArguments;
    }

    private static @Nullable Expression matchMethodParameterType(Expression argument, Class<?> parameter) {
        Type argumentType = argument.getType();
        if (Types.isAssignableFrom(parameter, (Type)argumentType)) {
            return argument;
        }
        if (parameter == Object.class && Primitive.of((Type)argumentType) != null) {
            return argument;
        }
        if (argumentType == Object.class && Primitive.of((Type)argumentType) == null) {
            return EnumUtils.convert(argument, parameter);
        }
        if (parameter == BigDecimal.class && Primitive.ofBoxOr((Type)argumentType) != null) {
            return EnumUtils.convert(argument, parameter);
        }
        return null;
    }

    static JoinType toLinq4jJoinType(JoinRelType joinRelType) {
        switch (joinRelType) {
            case INNER: {
                return JoinType.INNER;
            }
            case LEFT: {
                return JoinType.LEFT;
            }
            case RIGHT: {
                return JoinType.RIGHT;
            }
            case FULL: {
                return JoinType.FULL;
            }
            case SEMI: {
                return JoinType.SEMI;
            }
            case ANTI: {
                return JoinType.ANTI;
            }
        }
        throw new IllegalStateException("Unable to convert " + (Object)((Object)joinRelType) + " to Linq4j JoinType");
    }

    static Expression generatePredicate(EnumerableRelImplementor implementor, RexBuilder rexBuilder, RelNode left, RelNode right, PhysType leftPhysType, PhysType rightPhysType, RexNode condition) {
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression left_ = Expressions.parameter((Type)leftPhysType.getJavaRowType(), (String)"left");
        ParameterExpression right_ = Expressions.parameter((Type)rightPhysType.getJavaRowType(), (String)"right");
        RexProgramBuilder program = new RexProgramBuilder(((RelDataTypeFactory.FieldInfoBuilder)implementor.getTypeFactory().builder().addAll(left.getRowType().getFieldList())).addAll(right.getRowType().getFieldList()).build(), rexBuilder);
        program.addCondition(condition);
        builder.add((Statement)Expressions.return_(null, (Expression)RexToLixTranslator.translateCondition(program.getProgram(), implementor.getTypeFactory(), builder, new RexToLixTranslator.InputGetterImpl((Map<Expression, PhysType>)ImmutableMap.of((Object)left_, (Object)leftPhysType, (Object)right_, (Object)rightPhysType)), implementor.allCorrelateVariables, implementor.getConformance())));
        return Expressions.lambda(Predicate2.class, (BlockStatement)builder.toBlock(), (ParameterExpression[])new ParameterExpression[]{left_, right_});
    }

    static Expression tumblingWindowSelector(PhysType inputPhysType, PhysType outputPhysType, Expression wmColExpr, Expression windowSizeExpr, Expression offsetExpr) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        ParameterExpression parameter = Expressions.parameter((Type)Primitive.box((Type)inputPhysType.getJavaRowType()), (String)"_input");
        int fieldCount = inputPhysType.getRowType().getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            Expression expression = inputPhysType.fieldReference((Expression)parameter, i, outputPhysType.getJavaFieldType(expressions.size()));
            expressions.add(expression);
        }
        Expression wmColExprToLong = EnumUtils.convert(wmColExpr, Long.TYPE);
        BinaryExpression windowStartExpr = Expressions.subtract((Expression)wmColExprToLong, (Expression)Expressions.modulo((Expression)Expressions.add((Expression)wmColExprToLong, (Expression)Expressions.subtract((Expression)windowSizeExpr, (Expression)offsetExpr)), (Expression)windowSizeExpr));
        expressions.add((Expression)windowStartExpr);
        BinaryExpression windowEndExpr = Expressions.add((Expression)windowStartExpr, (Expression)windowSizeExpr);
        expressions.add((Expression)windowEndExpr);
        return Expressions.lambda(Function1.class, (Expression)outputPhysType.record(expressions), (ParameterExpression[])new ParameterExpression[]{parameter});
    }

    public static Enumerable<@Nullable Object[]> sessionize(final Enumerator<@Nullable Object[]> inputEnumerator, final int indexOfWatermarkedColumn, final int indexOfKeyColumn, final long gap) {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<@Nullable Object[]> enumerator() {
                return new SessionizationEnumerator((Enumerator<Object[]>)inputEnumerator, indexOfWatermarkedColumn, indexOfKeyColumn, gap);
            }
        };
    }

    public static Enumerable<@Nullable Object[]> hopping(final Enumerator<@Nullable Object[]> inputEnumerator, final int indexOfWatermarkedColumn, final long emitFrequency, final long windowSize, final long offset) {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<@Nullable Object[]> enumerator() {
                return new HopEnumerator((Enumerator<Object[]>)inputEnumerator, indexOfWatermarkedColumn, emitFrequency, windowSize, offset);
            }
        };
    }

    private static List<Pair<Long, Long>> hopWindows(long tsMillis, long periodMillis, long sizeMillis, long offsetMillis) {
        long lastStart;
        ArrayList<Pair<Long, Long>> ret = new ArrayList<Pair<Long, Long>>(Math.toIntExact(sizeMillis / periodMillis));
        for (long start = lastStart = tsMillis - (tsMillis + periodMillis - offsetMillis) % periodMillis; start > tsMillis - sizeMillis; start -= periodMillis) {
            ret.add(new Pair<Long, Long>(start, start + sizeMillis));
        }
        return ret;
    }

    public static <TSource, TResult> Enumerable<TResult> tumbling(final Enumerable<TSource> inputEnumerable, final Function1<TSource, TResult> outSelector) {
        return new AbstractEnumerable<TResult>(){

            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    final Enumerator<TSource> inputs;
                    {
                        this.inputs = inputEnumerable.enumerator();
                    }

                    public TResult current() {
                        return outSelector.apply(this.inputs.current());
                    }

                    public boolean moveNext() {
                        return this.inputs.moveNext();
                    }

                    public void reset() {
                        this.inputs.reset();
                    }

                    public void close() {
                        this.inputs.close();
                    }
                };
            }
        };
    }

    public static @Nullable Expression generateCollatorExpression(@Nullable SqlCollation collation) {
        if (collation == null) {
            return null;
        }
        Collator collator = collation.getCollator();
        if (collator == null) {
            return null;
        }
        Locale locale = collation.getLocale();
        int strength = collator.getStrength();
        return Expressions.call(Utilities.class, (String)"generateCollator", (Expression[])new Expression[]{Expressions.new_(Locale.class, (Expression[])new Expression[]{Expressions.constant((Object)locale.getLanguage()), Expressions.constant((Object)locale.getCountry()), Expressions.constant((Object)locale.getVariant())}), Expressions.constant((Object)strength)});
    }

    public static Function<Object, Object> toExternal(RelDataType type, TimeZone timeZone) {
        switch (type.getSqlTypeName()) {
            case DATE: {
                return o -> {
                    int d = (Integer)o;
                    long v = (long)d * 86400000L;
                    v -= (long)timeZone.getOffset(v);
                    return new Date(v);
                };
            }
            case TIME: {
                return o -> {
                    long v = ((Integer)o).intValue();
                    v -= (long)timeZone.getOffset(v);
                    return new Time(v % 86400000L);
                };
            }
            case TIMESTAMP: {
                return o -> {
                    long v = (Long)o;
                    v -= (long)timeZone.getOffset(v);
                    return new Timestamp(v);
                };
            }
        }
        return Function.identity();
    }

    public static Function<@Nullable Object[], List<@Nullable Object>> toExternal(List<RelDataType> types, TimeZone timeZone) {
        Function[] functions = new Function[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            functions[i] = EnumUtils.toExternal(types.get(i), timeZone);
        }
        @Nullable Object[] objects = new Object[types.size()];
        return values -> {
            for (int i = 0; i < ((Object[])values).length; ++i) {
                objects[i] = values[i] == null ? null : functions[i].apply(values[i]);
            }
            return Arrays.asList((Object[])objects.clone());
        };
    }

    private static class HopEnumerator
    implements Enumerator<Object[]> {
        private final Enumerator<@Nullable Object[]> inputEnumerator;
        private final int indexOfWatermarkedColumn;
        private final long emitFrequency;
        private final long windowSize;
        private final long offset;
        private final Deque<@Nullable Object[]> list;

        HopEnumerator(Enumerator<@Nullable Object[]> inputEnumerator, int indexOfWatermarkedColumn, long slide, long windowSize, long offset) {
            this.inputEnumerator = inputEnumerator;
            this.indexOfWatermarkedColumn = indexOfWatermarkedColumn;
            this.emitFrequency = slide;
            this.windowSize = windowSize;
            this.offset = offset;
            this.list = new ArrayDeque<Object[]>();
        }

        public @Nullable Object[] current() {
            if (this.list.size() > 0) {
                return this.takeOne();
            }
            @Nullable Object[] current = (Object[])this.inputEnumerator.current();
            Object watermark = Objects.requireNonNull(current[this.indexOfWatermarkedColumn], "element[indexOfWatermarkedColumn]");
            List windows = EnumUtils.hopWindows(SqlFunctions.toLong(watermark), this.emitFrequency, this.windowSize, this.offset);
            for (Pair window : windows) {
                @Nullable Object[] curWithWindow = new Object[current.length + 2];
                System.arraycopy(current, 0, curWithWindow, 0, current.length);
                curWithWindow[current.length] = window.left;
                curWithWindow[current.length + 1] = window.right;
                this.list.offer(curWithWindow);
            }
            return this.takeOne();
        }

        public boolean moveNext() {
            return this.list.size() > 0 || this.inputEnumerator.moveNext();
        }

        public void reset() {
            this.inputEnumerator.reset();
            this.list.clear();
        }

        public void close() {
        }

        private @Nullable Object[] takeOne() {
            return Objects.requireNonNull(this.list.pollFirst(), "list.pollFirst()");
        }
    }

    private static class SessionizationEnumerator
    implements Enumerator<Object[]> {
        private final Enumerator<@Nullable Object[]> inputEnumerator;
        private final int indexOfWatermarkedColumn;
        private final int indexOfKeyColumn;
        private final long gap;
        private final Deque<@Nullable Object[]> list;
        private boolean initialized;

        SessionizationEnumerator(Enumerator<@Nullable Object[]> inputEnumerator, int indexOfWatermarkedColumn, int indexOfKeyColumn, long gap) {
            this.inputEnumerator = inputEnumerator;
            this.indexOfWatermarkedColumn = indexOfWatermarkedColumn;
            this.indexOfKeyColumn = indexOfKeyColumn;
            this.gap = gap;
            this.list = new ArrayDeque<Object[]>();
            this.initialized = false;
        }

        public @Nullable Object[] current() {
            if (!this.initialized) {
                this.initialize();
                this.initialized = true;
            }
            return this.list.removeFirst();
        }

        public boolean moveNext() {
            return this.initialized ? this.list.size() > 0 : this.inputEnumerator.moveNext();
        }

        public void reset() {
            this.list.clear();
            this.inputEnumerator.reset();
            this.initialized = false;
        }

        public void close() {
            this.list.clear();
            this.inputEnumerator.close();
            this.initialized = false;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void initialize() {
            ArrayList<@Nullable Object> elements = new ArrayList<Object>();
            elements.add(this.inputEnumerator.current());
            while (this.inputEnumerator.moveNext()) {
                elements.add(this.inputEnumerator.current());
            }
            HashMap<@Nullable Object, @Nullable SortedMultiMap> sessionKeyMap = new HashMap<Object, SortedMultiMap>();
            for (Object[] objectArray : elements) {
                @Nullable SortedMultiMap session = sessionKeyMap.computeIfAbsent(objectArray[this.indexOfKeyColumn], k -> new SortedMultiMap());
                Object watermark = Objects.requireNonNull(objectArray[this.indexOfWatermarkedColumn], "element[indexOfWatermarkedColumn]");
                Pair<Long, Long> initWindow = SessionizationEnumerator.computeInitWindow(SqlFunctions.toLong(watermark), this.gap);
                session.putMulti(initWindow, objectArray);
            }
            for (Map.Entry entry : sessionKeyMap.entrySet()) {
                HashMap<Pair<Long, Long>, ArrayList<@Nullable E>> finalWindowElementsMap = new HashMap();
                Pair<Long, Long> currentWindow = null;
                ArrayList<@Nullable E> tempElementList = new ArrayList();
                for (Map.Entry sessionEntry : ((SortedMultiMap)entry.getValue()).entrySet()) {
                    if (currentWindow == null || !SessionizationEnumerator.isOverlapped(currentWindow, (Pair)sessionEntry.getKey())) {
                        if (currentWindow != null) {
                            finalWindowElementsMap.put(currentWindow, new ArrayList(tempElementList));
                        }
                        currentWindow = (Pair<Long, Long>)sessionEntry.getKey();
                        tempElementList.clear();
                        tempElementList.addAll((Collection)sessionEntry.getValue());
                        continue;
                    }
                    currentWindow = SessionizationEnumerator.mergeWindows(currentWindow, (Pair)sessionEntry.getKey());
                    tempElementList.addAll((Collection)sessionEntry.getValue());
                }
                if (!tempElementList.isEmpty()) {
                    Objects.requireNonNull(currentWindow, "currentWindow is null");
                    finalWindowElementsMap.put(currentWindow, new ArrayList(tempElementList));
                }
                for (Map.Entry finalWindowElementsEntry : finalWindowElementsMap.entrySet()) {
                    for (Object[] element : (List)finalWindowElementsEntry.getValue()) {
                        @Nullable Object[] curWithWindow = new Object[element.length + 2];
                        System.arraycopy(element, 0, curWithWindow, 0, element.length);
                        curWithWindow[element.length] = ((Pair)finalWindowElementsEntry.getKey()).left;
                        curWithWindow[element.length + 1] = ((Pair)finalWindowElementsEntry.getKey()).right;
                        this.list.offer(curWithWindow);
                    }
                }
            }
        }

        private static boolean isOverlapped(Pair<Long, Long> a, Pair<Long, Long> b) {
            return (Long)b.left < (Long)a.right;
        }

        private static Pair<Long, Long> mergeWindows(Pair<Long, Long> a, Pair<Long, Long> b) {
            return new Pair<Long, Long>((Long)a.left <= (Long)b.left ? (Long)a.left : (Long)b.left, (Long)a.right >= (Long)b.right ? (Long)a.right : (Long)b.right);
        }

        private static Pair<Long, Long> computeInitWindow(long ts, long gap) {
            return new Pair<Long, Long>(ts, ts + gap);
        }
    }
}

