/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.runtime.FlatLists;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Iterables;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.UnmodifiableListIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ImmutableIntList
extends FlatLists.AbstractFlatList<Integer> {
    private final int[] ints;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final ImmutableIntList EMPTY = new EmptyImmutableIntList();

    private ImmutableIntList(int ... ints) {
        this.ints = ints;
    }

    public static ImmutableIntList of() {
        return EMPTY;
    }

    public static ImmutableIntList of(int ... ints) {
        return new ImmutableIntList((int[])ints.clone());
    }

    public static ImmutableIntList copyOf(Number ... numbers) {
        int[] ints = new int[numbers.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = numbers[i].intValue();
        }
        return new ImmutableIntList(ints);
    }

    public static ImmutableIntList copyOf(Iterable<? extends Number> list) {
        if (list instanceof ImmutableIntList) {
            return (ImmutableIntList)list;
        }
        Collection collection = list instanceof Collection ? (Collection)list : Lists.newArrayList(list);
        return ImmutableIntList.copyFromCollection(collection);
    }

    public static ImmutableIntList copyOf(Iterator<? extends Number> list) {
        return ImmutableIntList.copyFromCollection(Lists.newArrayList(list));
    }

    private static ImmutableIntList copyFromCollection(Collection<? extends Number> list) {
        int[] ints = new int[list.size()];
        int i = 0;
        for (Number number : list) {
            ints[i++] = number.intValue();
        }
        return new ImmutableIntList(ints);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.ints);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof ImmutableIntList ? Arrays.equals(this.ints, ((ImmutableIntList)obj).ints) : obj instanceof List && obj.equals(this);
    }

    public String toString() {
        return Arrays.toString(this.ints);
    }

    @Override
    public boolean isEmpty() {
        return this.ints.length == 0;
    }

    @Override
    public int size() {
        return this.ints.length;
    }

    @Override
    public Object[] toArray() {
        Object[] objects = new Object[this.ints.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.ints[i];
        }
        return objects;
    }

    @Override
    public <T> @Nullable T[] toArray(T @Nullable [] a) {
        int size = this.ints.length;
        if (((Object[])Nullness.castNonNull(a)).length < size) {
            Object[] objectArray = a = a.getClass() == Object[].class ? new Object[size] : (Object[])Array.newInstance(Objects.requireNonNull(a.getClass().getComponentType()), size);
        }
        if (a.getClass() == Integer[].class) {
            Integer[] integers = (Integer[])a;
            for (int i = 0; i < size; ++i) {
                integers[i] = this.ints[i];
            }
        } else {
            System.arraycopy(this.toArray(), 0, a, 0, size);
        }
        if (a.length > size) {
            a[size] = Nullness.castNonNull(null);
        }
        return a;
    }

    public int[] toIntArray() {
        return (int[])this.ints.clone();
    }

    public List<Integer> toIntegerList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.size());
        for (int i : this.ints) {
            arrayList.add(i);
        }
        return arrayList;
    }

    @Override
    public Integer get(int index) {
        return this.ints[index];
    }

    public int getInt(int index) {
        return this.ints[index];
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Integer> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Integer> listIterator(int index) {
        return new AbstractIndexedListIterator<Integer>(this.size(), index){

            @Override
            protected Integer get(int index) {
                return ImmutableIntList.this.get(index);
            }
        };
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o instanceof Integer) {
            return this.indexOf((Integer)o);
        }
        return -1;
    }

    public int indexOf(int seek) {
        for (int i = 0; i < this.ints.length; ++i) {
            if (this.ints[i] != seek) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        if (o instanceof Integer) {
            return this.lastIndexOf((Integer)o);
        }
        return -1;
    }

    public int lastIndexOf(int seek) {
        for (int i = this.ints.length - 1; i >= 0; --i) {
            if (this.ints[i] != seek) continue;
            return i;
        }
        return -1;
    }

    public ImmutableIntList append(Integer e) {
        return this.append((int)e);
    }

    public ImmutableIntList append(int element) {
        if (this.ints.length == 0) {
            return ImmutableIntList.of(element);
        }
        int[] newInts = Arrays.copyOf(this.ints, this.ints.length + 1);
        newInts[this.ints.length] = element;
        return new ImmutableIntList(newInts);
    }

    public static List<Integer> range(int lower, int upper) {
        return Functions.generate((int)(upper - lower), index -> lower + index);
    }

    public static ImmutableIntList identity(int count) {
        int[] integers = new int[count];
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = i;
        }
        return new ImmutableIntList(integers);
    }

    public ImmutableIntList appendAll(Iterable<Integer> list) {
        if (list instanceof Collection && ((Collection)list).isEmpty()) {
            return this;
        }
        return ImmutableIntList.copyOf(Iterables.concat((Iterable)this, list));
    }

    public ImmutableIntList incr(int offset) {
        int[] integers = new int[this.ints.length];
        for (int i = 0; i < this.ints.length; ++i) {
            integers[i] = this.ints[i] + offset;
        }
        return new ImmutableIntList(integers);
    }

    private static abstract class AbstractIndexedListIterator<E>
    extends UnmodifiableListIterator<E> {
        private final int size;
        private int position;

        protected abstract E get(int var1);

        protected AbstractIndexedListIterator(int size, int position) {
            Preconditions.checkPositionIndex((int)position, (int)size);
            this.size = size;
            this.position = position;
        }

        public final boolean hasNext() {
            return this.position < this.size;
        }

        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.get(this.position++);
        }

        public final int nextIndex() {
            return this.position;
        }

        public final boolean hasPrevious() {
            return this.position > 0;
        }

        public final E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.get(--this.position);
        }

        public final int previousIndex() {
            return this.position - 1;
        }
    }

    private static class EmptyImmutableIntList
    extends ImmutableIntList {
        private EmptyImmutableIntList() {
            super(new int[0]);
        }

        @Override
        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> @Nullable T[] toArray(T @Nullable [] a) {
            if (((Object[])Nullness.castNonNull(a)).length > 0) {
                a[0] = Nullness.castNonNull(null);
            }
            return a;
        }

        @Override
        public Iterator<Integer> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public ListIterator<Integer> listIterator() {
            return Collections.emptyList().listIterator();
        }
    }
}

