/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.streaming.StreamingJobRecord;
import org.apache.kylin.metadata.streaming.StreamingJobRecordManager;
import org.apache.kylin.metadata.streaming.StreamingJobStats;
import org.apache.kylin.metadata.streaming.StreamingJobStatsManager;
import org.apache.kylin.rest.request.StreamingJobActionEnum;
import org.apache.kylin.rest.request.StreamingJobFilter;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.StreamingJobDataStatsResponse;
import org.apache.kylin.rest.response.StreamingJobResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.IndexPlanService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.ModelUtils;
import org.apache.kylin.rest.util.PagingUtil;
import org.apache.kylin.streaming.jobs.scheduler.StreamingScheduler;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.apache.kylin.streaming.request.StreamingJobStatsRequest;
import org.apache.kylin.streaming.request.StreamingJobUpdateRequest;
import org.apache.kylin.streaming.util.MetaInfoUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="streamingJobService")
public class StreamingJobService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(StreamingJobService.class);
    @Autowired
    @Qualifier(value="indexPlanService")
    IndexPlanService indexPlanService;
    @Autowired
    private AclEvaluate aclEvaluate;

    public void launchStreamingJob(String project, String modelId, JobTypeEnum jobType) {
        this.checkModelStatus(project, modelId, jobType);
        ModelUtils.checkPartitionColumn((String)project, (String)modelId, (String)MsgPicker.getMsg().getPartitionColumnStartError());
        this.initDefaultParser(project);
        StreamingScheduler scheduler = StreamingScheduler.getInstance();
        scheduler.submitJob(project, modelId, jobType);
    }

    public void checkModelStatus(String project, String modelId, JobTypeEnum jobType) {
        StreamingJobMeta jobMeta;
        String jobId = StreamingUtils.getJobId((String)modelId, (String)jobType.name());
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataModelManager modelMgr = NDataModelManager.getInstance((KylinConfig)config, (String)(jobMeta = ((StreamingJobManager)this.getManager(StreamingJobManager.class, project)).getStreamingJobByUuid(jobId)).getProject());
        NDataModel model = modelMgr.getDataModelDesc(jobMeta.getModelId());
        if (model.isBroken() || this.isBatchModelBroken(model)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.JOB_START_FAILURE, String.format(Locale.ROOT, MsgPicker.getMsg().getJobBrokenModelStartFailure(), model.getAlias()));
        }
    }

    public void stopStreamingJob(String project, String modelId, JobTypeEnum jobType) {
        StreamingScheduler scheduler = StreamingScheduler.getInstance();
        scheduler.stopJob(project, modelId, jobType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStopStreamingJob(String project, String modelId, JobTypeEnum jobType) {
        StreamingScheduler scheduler = StreamingScheduler.getInstance();
        scheduler.skipJobListener(project, StreamingUtils.getJobId((String)modelId, (String)jobType.name()), true);
        try {
            MetaInfoUpdater.updateJobState((String)project, (String)StreamingUtils.getJobId((String)modelId, (String)jobType.name()), (JobStatusEnum)JobStatusEnum.STOPPING);
            scheduler.killJob(project, modelId, jobType, JobStatusEnum.STOPPED);
        }
        finally {
            scheduler.skipJobListener(project, StreamingUtils.getJobId((String)modelId, (String)jobType.name()), false);
        }
    }

    public void updateStreamingJobParams(String project, String jobId, Map<String, String> params) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        this.checkJobParams(params);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)config, (String)project);
            mgr.updateStreamingJob(jobId, copyForWrite -> copyForWrite.setParams(params));
            return null;
        }, (String)project);
    }

    private void checkJobParams(Map<String, String> params) {
        String tableRefreshInterval = params.get("kylin.streaming.table-refresh-interval");
        StreamingUtils.parseTableRefreshInterval((String)tableRefreshInterval);
    }

    public void updateStreamingJobStatus(String project, List<String> jobIds, String action) {
        StreamingJobActionEnum.validate(action);
        String jobProject = project;
        Map<String, StreamingJobMeta> jobMap = this.getAllStreamingJobs(project).stream().collect(Collectors.toMap(RootPersistentEntity::getUuid, meta -> meta));
        for (String jobId : jobIds) {
            if (jobMap.containsKey(jobId)) {
                jobProject = jobMap.get(jobId).getProject();
            }
            this.aclEvaluate.checkProjectOperationPermission(jobProject);
            String[] jobIdPair = jobId.split("\\_");
            String modelId = jobIdPair[0];
            String jobType = "STREAMING_" + jobIdPair[1].toUpperCase(Locale.ROOT);
            switch (StreamingJobActionEnum.valueOf(action)) {
                case START: {
                    this.launchStreamingJob(jobProject, modelId, JobTypeEnum.valueOf((String)jobType));
                    break;
                }
                case STOP: {
                    this.stopStreamingJob(jobProject, modelId, JobTypeEnum.valueOf((String)jobType));
                    break;
                }
                case FORCE_STOP: {
                    this.forceStopStreamingJob(jobProject, modelId, JobTypeEnum.valueOf((String)jobType));
                    break;
                }
                case RESTART: {
                    this.forceStopStreamingJob(jobProject, modelId, JobTypeEnum.valueOf((String)jobType));
                    this.launchStreamingJob(jobProject, modelId, JobTypeEnum.valueOf((String)jobType));
                    break;
                }
            }
        }
    }

    public StreamingJobMeta updateStreamingJobInfo(StreamingJobUpdateRequest streamingJobUpdateRequest) {
        String project = streamingJobUpdateRequest.getProject();
        String modelId = streamingJobUpdateRequest.getModelId();
        String jobType = streamingJobUpdateRequest.getJobType();
        return (StreamingJobMeta)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)config, (String)project);
            return mgr.updateStreamingJob(StreamingUtils.getJobId((String)modelId, (String)jobType), copyForWrite -> {
                copyForWrite.setProcessId(streamingJobUpdateRequest.getProcessId());
                copyForWrite.setNodeInfo(streamingJobUpdateRequest.getNodeInfo());
                copyForWrite.setYarnAppId(streamingJobUpdateRequest.getYarnAppId());
                copyForWrite.setYarnAppUrl(streamingJobUpdateRequest.getYarnAppUrl());
                SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
                copyForWrite.setLastUpdateTime(simpleFormat.format(new Date()));
                Integer execId = copyForWrite.getJobExecutionId();
                copyForWrite.setJobExecutionId(Integer.valueOf(execId == null ? 1 : execId + 1));
            });
        }, (String)project);
    }

    public List<StreamingJobRecord> getStreamingJobRecordList(String jobId) {
        StreamingJobRecordManager mgr = StreamingJobRecordManager.getInstance();
        return mgr.queryByJobId(jobId);
    }

    public String addSegment(String project, String modelId, SegmentRange<?> rangeToMerge, String currLayer, String newSegId) {
        if (!StringUtils.isEmpty((CharSequence)currLayer)) {
            int layer = Integer.parseInt(currLayer) + 1;
            NDataSegment afterMergeSeg = (NDataSegment)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
                NDataflow df = dfMgr.getDataflow(modelId);
                return df != null ? dfMgr.mergeSegments(df, rangeToMerge, true, Integer.valueOf(layer), newSegId) : null;
            }, (String)project);
            return this.getSegmentId(afterMergeSeg);
        }
        NDataSegment newSegment = (NDataSegment)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            NDataflow df = dfMgr.getDataflow(modelId);
            return df != null ? dfMgr.appendSegmentForStreaming(df, rangeToMerge, newSegId) : null;
        }, (String)project);
        return this.getSegmentId(newSegment);
    }

    private String getSegmentId(NDataSegment newSegment) {
        return newSegment != null ? newSegment.getId() : "";
    }

    public void updateSegment(String project, String modelId, String segId, List<NDataSegment> removeSegmentList, String status, Long sourceCount) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            Long defaultSourceCount = -1L;
            NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            NDataflow df = dfMgr.getDataflow(modelId);
            if (df != null) {
                NDataSegment seg = df.getSegment(segId).copy();
                if (!defaultSourceCount.equals(sourceCount)) {
                    seg.setSourceCount(sourceCount.longValue());
                }
                seg.setStatus(SegmentStatusEnum.READY);
                NDataflowUpdate dfUpdate = new NDataflowUpdate(modelId);
                dfUpdate.setToUpdateSegs(new NDataSegment[]{seg});
                if (removeSegmentList != null) {
                    dfUpdate.setToRemoveSegs(removeSegmentList.toArray(new NDataSegment[0]));
                }
                if (!StringUtils.isEmpty((CharSequence)status)) {
                    dfUpdate.setStatus(RealizationStatusEnum.valueOf((String)status));
                }
                dfMgr.updateDataflow(dfUpdate);
            }
            return 0;
        }, (String)project);
    }

    public void deleteSegment(String project, String modelId, List<NDataSegment> removeSegmentList) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            NDataflowUpdate dfUpdate = new NDataflowUpdate(modelId);
            if (removeSegmentList != null) {
                dfUpdate.setToRemoveSegs(removeSegmentList.toArray(new NDataSegment[0]));
            }
            if (dfMgr.getDataflow(modelId) != null) {
                dfMgr.updateDataflow(dfUpdate);
            }
            return 0;
        }, (String)project);
    }

    public void updateLayout(String project, String modelId, List<NDataLayout> layouts) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataflowUpdate update = new NDataflowUpdate(modelId);
            update.setToAddOrUpdateLayouts(layouts.toArray(new NDataLayout[0]));
            NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            if (mgr.getDataflow(modelId) != null) {
                mgr.updateDataflow(update);
            }
            return 0;
        }, (String)project);
    }

    public void collectStreamingJobStats(StreamingJobStatsRequest statsRequst) {
        StreamingJobStatsManager statsMgr = this.getStreamingJobStatsManager();
        String jobId = statsRequst.getJobId();
        String project = statsRequst.getProject();
        Long batchRowNum = statsRequst.getBatchRowNum();
        Double rowsPerSecond = statsRequst.getRowsPerSecond();
        Long procTime = statsRequst.getProcessingTime();
        Long minDataLatency = statsRequst.getMinDataLatency();
        Long maxDataLatency = statsRequst.getMaxDataLatency();
        Long triggerStartTime = statsRequst.getTriggerStartTime();
        StreamingJobStats stats = new StreamingJobStats(jobId, project, batchRowNum, rowsPerSecond, procTime, minDataLatency, maxDataLatency, triggerStartTime);
        try {
            statsMgr.insert(stats);
        }
        catch (Exception exception) {
            logger.error("Write streaming job stats failed...");
        }
        Date date = new Date(System.currentTimeMillis());
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
            format.setTimeZone(TimeZone.getTimeZone(config.getTimeZone()));
            StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)config, (String)project);
            mgr.updateStreamingJob(jobId, copyForWrite -> {
                copyForWrite.setLastUpdateTime(format.format(date));
                copyForWrite.setLastBatchCount(Integer.valueOf(batchRowNum.intValue()));
            });
            return null;
        }, (String)project);
    }

    public StreamingJobStatsManager getStreamingJobStatsManager() {
        return StreamingJobStatsManager.getInstance();
    }

    public DataResult<List<StreamingJobResponse>> getStreamingJobList(StreamingJobFilter jobFilter, int offset, int limit) {
        if (!StringUtils.isEmpty((CharSequence)jobFilter.getProject())) {
            this.aclEvaluate.checkProjectOperationPermission(jobFilter.getProject());
        }
        List<StreamingJobMeta> list = CollectionUtils.isNotEmpty(jobFilter.getJobIds()) ? this.getAllStreamingJobsById(jobFilter.getProject(), jobFilter.getJobIds()) : this.getAllStreamingJobs(jobFilter.getProject());
        List jobIdList = list.stream().filter(item -> JobTypeEnum.STREAMING_BUILD == item.getJobType()).map(item -> StreamingUtils.getJobId((String)item.getModelId(), (String)item.getJobType().name())).collect(Collectors.toList());
        StreamingJobStatsManager statsMgr = StreamingJobStatsManager.getInstance();
        Map dataLatenciesMap = statsMgr.queryDataLatenciesByJobIds(jobIdList);
        List respList = list.stream().map(item -> {
            StreamingJobRecordManager recordMgr;
            StreamingJobRecord record;
            StreamingJobResponse resp = new StreamingJobResponse((StreamingJobMeta)item);
            if (JobStatusEnum.LAUNCHING_ERROR == resp.getCurrentStatus()) {
                resp.setLaunchingError(true);
                resp.setCurrentStatus(JobStatusEnum.ERROR);
            }
            String jobId = StreamingUtils.getJobId((String)resp.getModelId(), (String)resp.getJobType().name());
            if (dataLatenciesMap != null && dataLatenciesMap.containsKey(jobId)) {
                resp.setDataLatency(this.convertDataLatency((Long)dataLatenciesMap.get(jobId)));
            }
            if ((record = (recordMgr = StreamingJobRecordManager.getInstance()).getLatestOneByJobId(jobId)) != null) {
                resp.setLastStatusDuration(System.currentTimeMillis() - record.getCreateTime());
            }
            return resp;
        }).collect(Collectors.toList());
        Comparator comparator = StreamingJobService.propertyComparator((String)(StringUtils.isEmpty((CharSequence)jobFilter.getSortBy()) ? "last_modified" : jobFilter.getSortBy()), (!jobFilter.isReverse() ? 1 : 0) != 0);
        List filterList = respList.stream().filter(item -> {
            if (StringUtils.isEmpty((CharSequence)jobFilter.getModelName())) {
                return true;
            }
            return item.getModelName().contains(jobFilter.getModelName());
        }).filter(item -> {
            if (CollectionUtils.isEmpty(jobFilter.getModelNames())) {
                return true;
            }
            return jobFilter.getModelNames().contains(item.getModelName());
        }).filter(item -> {
            if (CollectionUtils.isEmpty(jobFilter.getJobTypes())) {
                return true;
            }
            return jobFilter.getJobTypes().contains(item.getJobType().name());
        }).filter(item -> {
            if (CollectionUtils.isEmpty(jobFilter.getStatuses())) {
                return true;
            }
            return jobFilter.getStatuses().contains(item.getCurrentStatus().name());
        }).sorted(comparator).collect(Collectors.toList());
        ArrayList targetList = new ArrayList(PagingUtil.cutPage(filterList, (int)offset, (int)limit));
        if (CollectionUtils.isNotEmpty(targetList)) {
            Map<String, NDataModel> modelMap = this.getAllDataModels(jobFilter.getProject());
            targetList.forEach(jobResponse -> this.setModelInfo((StreamingJobResponse)((Object)jobResponse), modelMap));
        }
        return new DataResult(targetList, filterList.size(), offset, limit);
    }

    void setModelInfo(StreamingJobResponse jobResponse, Map<String, NDataModel> modelMap) {
        String uuid = StreamingUtils.getModelId((String)jobResponse.getId());
        NDataModel dataModel = modelMap.get(uuid);
        if (dataModel == null || dataModel.isBroken() || this.isBatchModelBroken(dataModel) || ((NDataflowManager)this.getManager(NDataflowManager.class, jobResponse.getProject())).getDataflow(uuid).checkBrokenWithRelatedInfo()) {
            jobResponse.setModelBroken(true);
            return;
        }
        NIndexPlanManager mgr = (NIndexPlanManager)this.indexPlanService.getManager(NIndexPlanManager.class, jobResponse.getProject());
        jobResponse.setModelIndexes(mgr.getIndexPlan(uuid).getAllLayouts().size());
        jobResponse.setPartitionDesc(dataModel.getPartitionDesc());
    }

    private List<ProjectInstance> getAllProjects(String project) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NProjectManager prjMgr = NProjectManager.getInstance((KylinConfig)config);
        if (!StringUtils.isEmpty((CharSequence)project)) {
            return Arrays.asList(prjMgr.getProject(project));
        }
        return prjMgr.listAllProjects();
    }

    private Map<String, NDataModel> getAllDataModels(String project) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        HashMap<String, NDataModel> modelMap = new HashMap<String, NDataModel>();
        this.getAllProjects(project).forEach(instance -> {
            NDataModelManager modelMgr = NDataModelManager.getInstance((KylinConfig)config, (String)instance.getName());
            List modelList = modelMgr.listAllModels();
            if (CollectionUtils.isNotEmpty((Collection)modelList)) {
                modelList.forEach(model -> modelMap.put(model.getUuid(), (NDataModel)model));
            }
        });
        return modelMap;
    }

    List<StreamingJobMeta> getAllStreamingJobsById(String project, List<String> jobIds) {
        if (CollectionUtils.isEmpty(jobIds)) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((CharSequence)project)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{"project"});
        }
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        return jobIds.stream().map(arg_0 -> ((StreamingJobManager)StreamingJobManager.getInstance((KylinConfig)config, (String)project)).getStreamingJobByUuid(arg_0)).collect(Collectors.toList());
    }

    private List<StreamingJobMeta> getAllStreamingJobs(String project) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ArrayList<StreamingJobMeta> jobList = new ArrayList<StreamingJobMeta>();
        this.getAllProjects(project).stream().forEach(instance -> {
            StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)config, (String)instance.getName());
            jobList.addAll(mgr.listAllStreamingJobMeta());
        });
        return jobList;
    }

    public boolean isBatchModelBroken(NDataModel dataModel) {
        try {
            if (dataModel.isFusionModel()) {
                FusionModelManager fmMgr = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)dataModel.getProject());
                NDataModel batchModel = fmMgr.getFusionModel(dataModel.getFusionId()).getBatchModel();
                return batchModel.isBroken();
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public StreamingJobDataStatsResponse getStreamingJobDataStats(String jobId, Integer timeFilter) {
        StreamingJobDataStatsResponse resp = new StreamingJobDataStatsResponse();
        Message msg = MsgPicker.getMsg();
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
        if (timeFilter > 0) {
            if (timeFilter > 10080) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getIllegalTimeFilter());
            }
            calendar.add(12, -timeFilter.intValue());
            long startTime = calendar.getTimeInMillis();
            StreamingJobStatsManager statsMgr = StreamingJobStatsManager.getInstance();
            List statsList = statsMgr.queryStreamingJobStats(startTime, jobId);
            ArrayList<Integer> consumptionRateList = new ArrayList<Integer>();
            ArrayList<Long> procTimeList = new ArrayList<Long>();
            ArrayList<Long> minDataLatencyList = new ArrayList<Long>();
            ArrayList<Long> createDateList = new ArrayList<Long>();
            statsList.stream().forEach(item -> {
                consumptionRateList.add(item.getRowsPerSecond().intValue());
                procTimeList.add(item.getProcessingTime());
                minDataLatencyList.add(this.convertDataLatency(item.getMinDataLatency()));
                createDateList.add(item.getCreateTime());
            });
            resp.setConsumptionRateHist(consumptionRateList);
            resp.setProcessingTimeHist(procTimeList);
            resp.setDataLatencyHist(minDataLatencyList);
            resp.setCreateTime(createDateList);
        }
        return resp;
    }

    private Long convertDataLatency(Long dataLatency) {
        return dataLatency != null && dataLatency < 0L ? 0L : dataLatency;
    }

    public StreamingJobResponse getStreamingJobInfo(String jobId, String project) {
        StreamingJobRecordManager recordMgr;
        StreamingJobRecord record;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        StreamingJobManager mgr = StreamingJobManager.getInstance((KylinConfig)config, (String)project);
        StreamingJobMeta jobMeta = mgr.getStreamingJobByUuid(jobId);
        StreamingJobResponse resp = new StreamingJobResponse(jobMeta);
        StreamingJobStatsManager statsMgr = StreamingJobStatsManager.getInstance();
        StreamingJobStats stats = statsMgr.getLatestOneByJobId(jobId);
        if (stats != null) {
            resp.setDataLatency(stats.getMinDataLatency());
        }
        if ((record = (recordMgr = StreamingJobRecordManager.getInstance()).getLatestOneByJobId(jobId)) != null) {
            resp.setLastStatusDuration(System.currentTimeMillis() - record.getCreateTime());
        }
        return resp;
    }

    public InputStream getStreamingJobAllLog(String project, String jobId) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        ExecutableManager executableManager = (ExecutableManager)this.getManager(ExecutableManager.class, project);
        return executableManager.getStreamingOutputFromHDFS(jobId, Integer.MAX_VALUE).getVerboseMsgStream();
    }

    public String getStreamingJobSimpleLog(String project, String jobId) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        ExecutableManager executableManager = (ExecutableManager)this.getManager(ExecutableManager.class, project);
        return executableManager.getStreamingOutputFromHDFS(jobId).getVerboseMsg();
    }

    public void checkJobExecutionId(String project, String jobId, Integer execId) {
        StreamingJobMeta meta = ((StreamingJobManager)this.getManager(StreamingJobManager.class, project)).getStreamingJobByUuid(jobId);
        String msg = String.format(Locale.ROOT, "JobExecutionId(%d) is invalid", execId);
        Preconditions.checkState((boolean)ObjectUtils.equals((Object)execId, (Object)meta.getJobExecutionId()), (Object)msg);
    }
}

