/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.HashBiMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.AntiFlatChecker;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.graph.JoinsGraph;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.util.ComputedColumnRewriter;
import org.apache.kylin.query.util.QueryAliasMatchInfo;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.ModelReuseContext;
import org.apache.kylin.rec.SmartContext;
import org.apache.kylin.rec.model.GreedyModelTreesBuilder;
import org.apache.kylin.rec.model.ModelTree;
import org.apache.kylin.rec.model.ProposerProvider;
import org.apache.kylin.rec.query.LocalQueryRunner;
import org.apache.kylin.rec.query.QueryRunnerBuilder;
import org.apache.kylin.rec.util.CubeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMaster {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelMaster.class);
    private final AbstractContext.ModelContext modelContext;
    private final ProposerProvider proposerProvider;
    private final String project;

    public ModelMaster(AbstractContext.ModelContext modelContext) {
        this.modelContext = modelContext;
        this.proposerProvider = ProposerProvider.create(modelContext);
        this.project = modelContext.getProposeContext().getProject();
    }

    NDataModel proposeInitialModel() {
        NDataModel dataModel = new NDataModel();
        dataModel.setRootFactTableName(this.modelContext.getModelTree().getRootFactTable().getIdentity());
        dataModel.setDescription("");
        dataModel.setFilterCondition("");
        dataModel.setComputedColumnDescs((List)Lists.newArrayList());
        dataModel.setProject(this.project);
        FunctionDesc countStar = CubeUtils.newCountStarFuncDesc(dataModel);
        NDataModel.Measure countStarMeasure = CubeUtils.newMeasure(countStar, "COUNT_ALL", 100000);
        dataModel.setAllMeasures((List)Lists.newArrayList((Object[])new NDataModel.Measure[]{countStarMeasure}));
        log.info("Initialized a new model({}) for no compatible one to use.", (Object)dataModel.getId());
        return dataModel;
    }

    public NDataModel proposeJoins(NDataModel dataModel) {
        ModelReuseContext context;
        if (this.modelContext.getProposeContext() instanceof ModelReuseContext && !(context = (ModelReuseContext)this.modelContext.getProposeContext()).isCanCreateNewModel()) {
            Preconditions.checkState((dataModel != null ? 1 : 0) != 0, (Object)"There is no compatible model to accelerate this sql.");
            return dataModel;
        }
        log.info("Start proposing join relations.");
        if (dataModel == null) {
            dataModel = this.proposeInitialModel();
        }
        dataModel = this.proposerProvider.getJoinProposer().propose(dataModel);
        log.info("Proposing join relations completed successfully.");
        return dataModel;
    }

    public NDataModel proposeScope(NDataModel dataModel) {
        log.info("Start proposing dimensions and measures.");
        dataModel = this.proposerProvider.getScopeProposer().propose(dataModel);
        log.info("Proposing dimensions and measures completed successfully.");
        return dataModel;
    }

    public NDataModel proposeComputedColumn(NDataModel dataModel) {
        log.info("Start proposing computed columns.");
        this.initAntiFlatChecker(this.modelContext, dataModel);
        this.initExcludedChecker(this.modelContext);
        boolean turnOnCC = this.modelContext.getProposeContext().getKapConfig().getKylinConfig().isConvertExpressionToCcEnabled();
        if (!turnOnCC) {
            log.warn("The feature of proposing computed column in Kyligence Enterprise has been turned off.");
            return dataModel;
        }
        ArrayList originalCCs = Lists.newArrayList((Iterable)dataModel.getComputedColumnDescs());
        try {
            dataModel = this.proposerProvider.getComputedColumnProposer().propose(dataModel);
            if (this.modelContext.isNeedUpdateCC()) {
                log.info("Start using proposed computed columns to update the model({})", (Object)dataModel.getId());
                this.updateContextWithCC(dataModel);
            }
            log.info("Proposing computed column completed successfully.");
        }
        catch (Exception e) {
            log.error("Propose failed, will discard new computed columns.", (Throwable)e);
            dataModel.setComputedColumnDescs((List)originalCCs);
        }
        return dataModel;
    }

    private void initAntiFlatChecker(AbstractContext.ModelContext modelContext, NDataModel dataModel) {
        if (modelContext.getAntiFlatChecker() == null) {
            AntiFlatChecker checker = new AntiFlatChecker(dataModel.getJoinTables(), dataModel);
            modelContext.setAntiFlatChecker(checker);
        }
    }

    private void initExcludedChecker(AbstractContext.ModelContext modelContext) {
        if (modelContext.getExcludedChecker() == null) {
            KylinConfig kylinConfig = modelContext.getProposeContext().getSmartConfig().getKylinConfig();
            ColExcludedChecker excludedChecker = new ColExcludedChecker(kylinConfig, this.project, modelContext.getTargetModel());
            modelContext.setExcludedChecker(excludedChecker);
        }
    }

    public NDataModel shrinkComputedColumn(NDataModel dataModel) {
        return this.proposerProvider.getShrinkComputedColumnProposer().propose(dataModel);
    }

    private void updateContextWithCC(NDataModel dataModel) {
        ArrayList originQueryList = Lists.newArrayList();
        this.modelContext.getModelTree().getOlapContexts().stream().filter(context -> !StringUtils.isEmpty((CharSequence)context.getSql())).forEach(context -> originQueryList.add(context.getSql()));
        if (originQueryList.isEmpty()) {
            log.warn("Failed to replace cc expression in original sql with proposed computed columns, early termination of the method of updateContextWithCC");
            return;
        }
        KylinConfig kylinConfig = this.modelContext.getProposeContext().getSmartConfig().getKylinConfig();
        try (LocalQueryRunner extractor = new QueryRunnerBuilder(this.project, kylinConfig, originQueryList.toArray(new String[0])).of(Lists.newArrayList((Object[])new NDataModel[]{dataModel})).build();){
            log.info("Start to rebuild modelTrees after replace cc expression with cc name.");
            extractor.execute();
            AbstractContext proposeContext = this.modelContext.getProposeContext();
            List<ModelTree> modelTrees = new GreedyModelTreesBuilder(kylinConfig, this.project, proposeContext).build(extractor.filterNonModelViewOlapContexts(), null);
            ModelTree updatedModelTree = null;
            for (ModelTree modelTree : modelTrees) {
                boolean match = proposeContext instanceof SmartContext ? modelTree.hasSameSubGraph(dataModel) : modelTree.isExactlyMatch(dataModel, proposeContext.isPartialMatch(), proposeContext.isPartialMatchNonEqui());
                if (!match) continue;
                updatedModelTree = modelTree;
                break;
            }
            if (updatedModelTree == null) {
                return;
            }
            this.modelContext.setModelTree(updatedModelTree);
            this.updateOlapCtxWithCC(updatedModelTree, dataModel);
            log.info("Rebuild modelTree successfully.");
        }
        catch (InterruptedException e) {
            log.warn("Interrupted!!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.warn("NModelMaster.updateContextWithCC failed to update model tree", (Throwable)e);
        }
    }

    private void updateOlapCtxWithCC(ModelTree modelTree, NDataModel model) {
        boolean matchPartial = this.modelContext.getProposeContext().isPartialMatch();
        modelTree.getOlapContexts().forEach(context -> {
            JoinsGraph joinsGraph = context.getJoinsGraph() == null ? new JoinsGraph(context.getFirstTableScan().getTableRef(), context.getJoins()) : context.getJoinsGraph();
            Map matches = joinsGraph.matchAlias(model.getJoinsGraph(), matchPartial);
            if (matches == null || matches.isEmpty()) {
                return;
            }
            Set cols = this.modelContext.getExcludedChecker().filterRelatedExcludedColumn(model);
            QueryAliasMatchInfo matchInfo = new QueryAliasMatchInfo((BiMap)HashBiMap.create((Map)matches), null);
            matchInfo.getExcludedColumns().addAll(cols);
            ComputedColumnRewriter.rewriteCcInnerCol((OlapContext)context, (NDataModel)model, (QueryAliasMatchInfo)matchInfo);
        });
    }
}

