/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.job.StepEnum;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.IndexPlanOptimizeJobHandler;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.base.Preconditions;

public class NSparkIndexPlanOptimizeJob
extends DefaultExecutable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NSparkIndexPlanOptimizeJob.class);

    public NSparkIndexPlanOptimizeJob() {
    }

    public NSparkIndexPlanOptimizeJob(Object notSetId) {
        super(notSetId);
    }

    public static NSparkIndexPlanOptimizeJob create(IndexPlanOptimizeJobHandler.IndexPlanOptimizeJobParam indexOptJobParam) {
        return NSparkIndexPlanOptimizeJob.internalCreate(indexOptJobParam);
    }

    public static NSparkIndexPlanOptimizeJob internalCreate(IndexPlanOptimizeJobHandler.IndexPlanOptimizeJobParam indexOptJobParam) {
        String project = indexOptJobParam.getProject();
        String dataflowId = indexOptJobParam.getDataflowId();
        NDataflowManager dataflowMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NDataflow dataflow = dataflowMgr.getDataflow(dataflowId);
        Preconditions.checkArgument((indexOptJobParam.getSubmitter() != null ? 1 : 0) != 0);
        NSparkIndexPlanOptimizeJob job = new NSparkIndexPlanOptimizeJob();
        job.setId(indexOptJobParam.getJobId());
        job.setProject(project);
        job.setName(indexOptJobParam.getJobType().toString());
        job.setJobType(indexOptJobParam.getJobType());
        job.setSubmitter(indexOptJobParam.getSubmitter());
        job.setTargetSubject(dataflow.getModel().getUuid());
        job.setParam("jobId", indexOptJobParam.getJobId());
        job.setParam("project", project);
        job.setParam("dataflowId", dataflowId);
        job.setParam("kylin.planner.initializeCuboidCount", String.valueOf(indexOptJobParam.getInitializeCuboidCount()));
        job.setParam("kylin.planner.maxCuboidCount", String.valueOf(indexOptJobParam.getMaxCuboidCount()));
        job.setParam("kylin.planner.maxCuboidChangeCount", String.valueOf(indexOptJobParam.getMaxCuboidChangeCount()));
        job.setParam("dataRangeStart", String.valueOf(indexOptJobParam.getDataRangeStart()));
        job.setParam("dataRangeEnd", String.valueOf(indexOptJobParam.getDataRangeEnd()));
        job.setParam("kylin.planner.autoApproveEnabled", String.valueOf(indexOptJobParam.isAutoApproveEnabled()));
        job.setParam("kylin.planner.operationToken", String.valueOf(indexOptJobParam.getOperationToken()));
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        StepEnum.OPTIMIZE_INDEX_PLAN.create(job, config);
        return job;
    }

    static {
        JobFactory.register((String)"INDEX_PLAN_OPTIMIZE_JOB_FACTORY", (JobFactory)new IndexPlanOptimizeJobFactory());
    }

    public static class IndexPlanOptimizeJobFactory
    extends JobFactory {
        protected IndexPlanOptimizeJobFactory() {
        }

        protected NSparkIndexPlanOptimizeJob create(JobFactory.JobBuildParams indexOptJobParam) {
            return NSparkIndexPlanOptimizeJob.create((IndexPlanOptimizeJobHandler.IndexPlanOptimizeJobParam)indexOptJobParam);
        }
    }

    public static class IndexPlanOptimizeStep
    extends NSparkExecutable {
        public IndexPlanOptimizeStep() {
        }

        public IndexPlanOptimizeStep(Object notSetId) {
            super(notSetId);
        }

        public IndexPlanOptimizeStep(String sparkSubmitClassName) {
            this.setSparkSubmitClassName(sparkSubmitClassName);
            this.setName("IndexPlan Optimize");
        }

        @Override
        protected ExecuteResult doWork(JobContext context) throws ExecuteException {
            ExecuteResult result = super.doWork(context);
            if (!result.succeed()) {
                return result;
            }
            if (this.checkSuicide()) {
                log.info("This Index Plan Optimize job seems meaningless now, skipped");
                return null;
            }
            return result;
        }

        @Override
        protected Set<String> getMetadataDumpList(KylinConfig config) {
            LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
            NDataflow df = NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject()).getDataflow(this.getDataflowId());
            dumpList.addAll(df.collectPrecalculationResource());
            dumpList.addAll(this.getLogicalViewMetaDumpList(config));
            return dumpList;
        }
    }
}

