/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.utils.HiveTransactionTableHelper;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.source.hive.HiveCmdBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkCleanupTransactionalTableStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(SparkCleanupTransactionalTableStep.class);

    public SparkCleanupTransactionalTableStep() {
        this.setName("Clean Up Intermediate Table");
    }

    public SparkCleanupTransactionalTableStep(Object notSetId) {
        super(notSetId);
    }

    @Override
    public ExecuteResult doWork(JobContext context) throws ExecuteException {
        KylinConfig config = this.getConfig();
        String jobId = this.getParam("jobId");
        String dir = config.getJobTmpTransactionalTableDir(this.getProject(), jobId);
        logger.info("should clean dir :{} ", (Object)dir);
        Path path = new Path(dir);
        try {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            if (fs.exists(path)) {
                for (FileStatus fileStatus : fs.listStatus(path)) {
                    HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder(config);
                    String tableFullName = fileStatus.getPath().getName();
                    hiveCmdBuilder.addStatement(SparkCleanupTransactionalTableStep.generateDropTableCommand(tableFullName));
                    String cmd = hiveCmdBuilder.toString();
                    this.doExecuteCliCommand(tableFullName, cmd);
                }
                fs.delete(path, true);
            }
        }
        catch (IOException e) {
            logger.error("Can not delete intermediate table.", (Throwable)e);
            throw new ExecuteException("Can not delete intermediate table");
        }
        return ExecuteResult.createSucceed();
    }

    private void doExecuteCliCommand(String tableFullName, String cmd) {
        if (StringUtils.isEmpty((CharSequence)cmd)) {
            return;
        }
        try {
            CliCommandExecutor cliCommandExecutor = new CliCommandExecutor();
            CliCommandExecutor.CliCmdExecResult result = cliCommandExecutor.execute(cmd, null);
            if (result.getCode() != 0) {
                logger.error("execute drop intermediate table return fail, table : {}, code :{}", (Object)tableFullName, (Object)result.getCode());
            } else {
                logger.info("execute drop intermediate table succeeded, table :{} ", (Object)tableFullName);
            }
        }
        catch (ShellException e) {
            logger.error(String.format(Locale.ROOT, "execute drop intermediate table error, table :%s ", tableFullName), (Throwable)e);
        }
    }

    public static String generateDropTableCommand(String tableFullName) {
        if (StringUtils.isEmpty((CharSequence)tableFullName)) {
            logger.info("The table name is empty.");
            return "";
        }
        String tableName = tableFullName;
        if (tableFullName.contains(".") && !tableFullName.endsWith(".")) {
            String database = tableFullName.substring(0, tableFullName.indexOf("."));
            tableName = tableFullName.substring(tableFullName.indexOf(".") + 1);
            return HiveTransactionTableHelper.generateHiveInitStatements(database) + HiveTransactionTableHelper.generateDropTableStatement(tableName);
        }
        return HiveTransactionTableHelper.generateDropTableStatement(tableName);
    }
}

