/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.FusionModel;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.rest.constant.ModelAttributeEnum;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.ModelQuerySupporter;
import org.apache.kylin.rest.service.params.ModelQueryParams;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.ModelTriple;
import org.apache.kylin.rest.util.ModelTripleComparator;
import org.apache.kylin.rest.util.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModelQueryService
extends BasicService
implements ModelQuerySupporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelQueryService.class);
    public static final String LAST_MODIFIED = "lastModified";
    public static final String USAGE = "usage";
    public static final String STORAGE = "storage";
    public static final String QUERY_HIT_COUNT = "queryHitCount";
    public static final String EXPANSION_RATE = "expansionrate";
    private static final String RECOMMENDATIONS_COUNT_LOWER_CAMEL = "recommendationsCount";
    @Autowired
    public AclEvaluate aclEvaluate;

    public List<ModelTriple> getModels(ModelQueryParams queryParam) {
        String projectName = queryParam.getProjectName();
        List<ModelTriple> modelTripleList = this.matchFirstModels(queryParam);
        modelTripleList = this.filterModels(modelTripleList, queryParam);
        modelTripleList = this.sortModels(modelTripleList, projectName, queryParam.getSortBy(), queryParam.isReverse());
        return modelTripleList;
    }

    public List<ModelTriple> matchFirstModels(ModelQueryParams queryParam) {
        String projectName = queryParam.getProjectName();
        boolean exactMatch = queryParam.isExactMatch();
        Long lastModifyFrom = queryParam.getLastModifyFrom();
        Long lastModifyTo = queryParam.getLastModifyTo();
        return ((NDataflowManager)this.getManager(NDataflowManager.class, projectName)).listAllDataflows(true).parallelStream().map(df -> new ModelTriple(df, df.checkBrokenWithRelatedInfo() ? this.getBrokenModel(projectName, df.getId()) : df.getModel())).filter(p -> !(Objects.nonNull(lastModifyFrom) && lastModifyFrom > p.getDataModel().getLastModified() || Objects.nonNull(lastModifyTo) && lastModifyTo <= p.getDataModel().getLastModified() || !ModelUtils.isArgMatch((String)queryParam.getModelAliasOrOwner(), (boolean)exactMatch, (String)p.getDataModel().getAlias()) && !ModelUtils.isArgMatch((String)queryParam.getModelAliasOrOwner(), (boolean)exactMatch, (String)p.getDataModel().getOwner()) || !ModelUtils.isArgMatch((String)queryParam.getModelAlias(), (boolean)exactMatch, (String)p.getDataModel().getAlias()) || !ModelUtils.isArgMatch((String)queryParam.getOwner(), (boolean)exactMatch, (String)p.getDataModel().getOwner()) || p.getDataModel().fusionModelBatchPart())).collect(Collectors.toList());
    }

    public List<ModelTriple> filterModels(List<ModelTriple> modelTripleList, ModelQueryParams elem) {
        HashSet modelAttributeSet = Sets.newHashSet((Iterable)(elem.getModelAttributes() == null ? Collections.emptyList() : elem.getModelAttributes()));
        if (StringUtils.isNotEmpty((CharSequence)elem.getModelId())) {
            modelTripleList.removeIf(t -> !t.getDataModel().getUuid().equals(elem.getModelId()));
        }
        boolean streamingEnabled = KylinConfig.getInstanceFromEnv().isStreamingEnabled();
        modelTripleList = modelTripleList.parallelStream().filter(triple -> triple.getDataModel().isAccessible(streamingEnabled)).collect(Collectors.toList());
        if (!modelAttributeSet.isEmpty()) {
            modelTripleList = modelTripleList.parallelStream().filter(t -> this.filterModelAttribute((ModelTriple)t, modelAttributeSet)).collect(Collectors.toList());
        }
        return modelTripleList;
    }

    public boolean filterModelAttribute(ModelTriple modelTriple, Set<ModelAttributeEnum> modelAttributeSet) {
        NDataModel.ModelType modelType = modelTriple.getDataModel().getModelType();
        switch (modelType) {
            case BATCH: {
                return modelAttributeSet.contains(ModelAttributeEnum.BATCH);
            }
            case HYBRID: {
                return modelAttributeSet.contains(ModelAttributeEnum.HYBRID);
            }
            case STREAMING: {
                return modelAttributeSet.contains(ModelAttributeEnum.STREAMING);
            }
        }
        return false;
    }

    public List<ModelTriple> sortModels(List<ModelTriple> modelTripleList, String projectName, String sortBy, boolean reverse) {
        if (StringUtils.isEmpty((CharSequence)sortBy)) {
            if (((NProjectManager)this.getManager(NProjectManager.class)).getProject(projectName).isSemiAutoMode()) {
                return modelTripleList.stream().sorted(new ModelTripleComparator(RECOMMENDATIONS_COUNT_LOWER_CAMEL, !reverse, 2)).collect(Collectors.toList());
            }
            return modelTripleList.stream().sorted(new ModelTripleComparator(LAST_MODIFIED, !reverse, 2)).collect(Collectors.toList());
        }
        switch (sortBy) {
            case "usage": {
                return modelTripleList.stream().sorted(new ModelTripleComparator(QUERY_HIT_COUNT, !reverse, 1)).collect(Collectors.toList());
            }
            case "recommendations_count": {
                return modelTripleList.stream().sorted(new ModelTripleComparator(RECOMMENDATIONS_COUNT_LOWER_CAMEL, !reverse, 2)).collect(Collectors.toList());
            }
            case "storage": {
                return this.sortByStorage(modelTripleList, projectName, reverse);
            }
            case "expansionrate": {
                return this.sortByExpansionRate(modelTripleList, projectName, reverse);
            }
        }
        return modelTripleList.stream().sorted(new ModelTripleComparator(LAST_MODIFIED, !reverse, 2)).collect(Collectors.toList());
    }

    private List<ModelTriple> sortByStorage(List<ModelTriple> tripleList, String projectName, boolean reverse) {
        NDataflowManager dfMgr = (NDataflowManager)this.getManager(NDataflowManager.class, projectName);
        tripleList.parallelStream().filter(t -> t.getDataModel().isFusionModel()).forEach(t -> {
            BiConsumer<NDataflow, NDataflow> expansionRateFunc = (streamingDataflow, batchDataflow) -> {
                long totalStorageSize = streamingDataflow.getStorageBytesSize() + batchDataflow.getStorageBytesSize();
                t.setCalcObject((Serializable)Long.valueOf(totalStorageSize));
            };
            this.calcOfFusionModel(projectName, (ModelTriple)t, dfMgr, expansionRateFunc);
        });
        tripleList.parallelStream().filter(t -> !t.getDataModel().isFusionModel()).forEach(t -> t.setCalcObject((Serializable)Long.valueOf(t.getDataflow().getStorageBytesSize())));
        return tripleList.stream().sorted(new ModelTripleComparator("calcObject", !reverse, 3)).collect(Collectors.toList());
    }

    private List<ModelTriple> sortByExpansionRate(List<ModelTriple> tripleList, String projectName, boolean reverse) {
        NDataflowManager dfMgr = (NDataflowManager)this.getManager(NDataflowManager.class, projectName);
        tripleList.parallelStream().filter(t -> t.getDataModel().isFusionModel()).forEach(t -> {
            BiConsumer<NDataflow, NDataflow> expansionRateFunc = (streamingDataflow, batchDataflow) -> {
                long totalStorageSize = batchDataflow.getStorageBytesSize() + streamingDataflow.getStorageBytesSize();
                long totalSourceSize = batchDataflow.getSourceBytesSize() + streamingDataflow.getSourceBytesSize();
                t.setCalcObject((Serializable)((Object)ModelUtils.computeExpansionRate((long)totalStorageSize, (long)totalSourceSize)));
            };
            this.calcOfFusionModel(projectName, (ModelTriple)t, dfMgr, expansionRateFunc);
        });
        tripleList.parallelStream().filter(t -> !t.getDataModel().isFusionModel()).forEach(t -> {
            NDataflow dataflow = t.getDataflow();
            t.setCalcObject((Serializable)((Object)ModelUtils.computeExpansionRate((long)dataflow.getStorageBytesSize(), (long)dataflow.getSourceBytesSize())));
        });
        List sorted = !reverse ? tripleList.stream().sorted(Comparator.comparing(a -> new BigDecimal((String)((Object)a.getCalcObject())))).collect(Collectors.toList()) : tripleList.stream().sorted((a, b) -> new BigDecimal((String)((Object)b.getCalcObject())).compareTo(new BigDecimal((String)((Object)a.getCalcObject())))).collect(Collectors.toList());
        List unknownModels = sorted.stream().filter(model -> "-1".equalsIgnoreCase((String)((Object)model.getCalcObject()))).collect(Collectors.toList());
        List<ModelTriple> models = sorted.stream().filter(model -> !"-1".equalsIgnoreCase((String)((Object)model.getCalcObject()))).collect(Collectors.toList());
        models.addAll(unknownModels);
        return models;
    }

    private void calcOfFusionModel(String projectName, ModelTriple t, NDataflowManager dfMgr, BiConsumer<NDataflow, NDataflow> func) {
        NDataModel modelDesc = t.getDataModel();
        FusionModel fusionModel = ((FusionModelManager)this.getManager(FusionModelManager.class, projectName)).getFusionModel(modelDesc.getFusionId());
        NDataModel batchModel = fusionModel.getBatchModel();
        NDataflow streamingDataflow = t.getDataflow();
        NDataflow batchDataflow = dfMgr.getDataflow(batchModel.getId());
        func.accept(streamingDataflow, batchDataflow);
    }

    public NDataModel getBrokenModel(String project, String modelId) {
        NDataModel model = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataModelDescWithoutInit(modelId);
        model.setBroken(true);
        return model;
    }
}

