/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerApiListingReader
implements ApiListingBuilderPlugin {
    @Override
    public void apply(ApiListingContext apiListingContext) {
        Optional<Class<?>> controller = apiListingContext.getResourceGroup().getControllerClass();
        if (controller.isPresent()) {
            Optional<Api> apiAnnotation = Optional.ofNullable((Api)AnnotationUtils.findAnnotation(controller.get(), Api.class));
            Set<springfox.documentation.service.Tag> oasTags = this.tagsFromOasAnnotations(controller.get());
            String description = apiAnnotation.map(Api::description).map(BuilderDefaults::emptyToNull).orElse(null);
            TreeSet<String> tagSet = new TreeSet<String>();
            if (oasTags.isEmpty()) {
                tagSet.addAll(apiAnnotation.map(this.tags()).orElse(new TreeSet()));
                if (tagSet.isEmpty()) {
                    tagSet.add(apiListingContext.getResourceGroup().getGroupName());
                }
            }
            apiListingContext.apiListingBuilder().description(description).tagNames(tagSet).tags(oasTags);
        }
    }

    private Set<springfox.documentation.service.Tag> tagsFromOasAnnotations(Class<?> controller) {
        Tag tag;
        HashSet<springfox.documentation.service.Tag> controllerTags = new HashSet<springfox.documentation.service.Tag>();
        io.swagger.v3.oas.annotations.tags.Tags tags = (io.swagger.v3.oas.annotations.tags.Tags)AnnotationUtils.findAnnotation(controller, io.swagger.v3.oas.annotations.tags.Tags.class);
        if (tags != null) {
            Arrays.stream(tags.value()).forEach(t -> controllerTags.add(new springfox.documentation.service.Tag(t.name(), t.description())));
        }
        if ((tag = (Tag)AnnotationUtils.findAnnotation(controller, Tag.class)) != null) {
            controllerTags.add(new springfox.documentation.service.Tag(tag.name(), tag.description()));
        }
        return controllerTags;
    }

    private Function<Api, Set<String>> tags() {
        return input -> Stream.of(input.tags()).filter(Tags.emptyTags()).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

