/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.runtime;

import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelNode;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.DryRunSucceedException;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.engine.exec.ExecuteResult;
import org.apache.kylin.query.engine.exec.sparder.QueryEngine;
import org.apache.kylin.query.mask.QueryResultMasks;
import org.apache.kylin.query.runtime.CalciteToSparkPlaner;
import org.apache.kylin.query.runtime.plan.ResultPlan;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkInternalAgent;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkEngine
implements QueryEngine {
    private static final Logger log = LoggerFactory.getLogger(SparkEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset<Row> toSparkPlan(DataContext dataContext, RelNode relNode) {
        QueryContext.currentTrace().startSpan("PREPARE_AND_SUBMIT_JOB");
        log.info("Begin planning spark plan.");
        long start = System.currentTimeMillis();
        CalciteToSparkPlaner calciteToSparkPlaner = new CalciteToSparkPlaner(dataContext);
        try {
            calciteToSparkPlaner.go(relNode);
        }
        finally {
            calciteToSparkPlaner.cleanCache();
        }
        LogicalPlan plan = calciteToSparkPlaner.getResult();
        Dataset df = SparkInternalAgent.getDataFrame((SparkSession)SparderEnv.getSparkSession(), (LogicalPlan)plan);
        QueryContext.current().record("to_spark_plan");
        long takeTime = System.currentTimeMillis() - start;
        log.info("Plan take {} ms", (Object)takeTime);
        return df;
    }

    public List<List<String>> compute(DataContext dataContext, RelNode relNode) {
        return ImmutableList.copyOf((Iterable)this.computeToIterable(dataContext, relNode).getRows());
    }

    public ExecuteResult computeToIterable(DataContext dataContext, RelNode relNode) {
        Dataset<Row> sparkPlan = QueryResultMasks.maskResult(this.toSparkPlan(dataContext, relNode));
        if (QueryContext.current().isDryRun()) {
            throw new DryRunSucceedException("DryRun succeed. Query is stopped due to DryRun enabled.", sparkPlan.queryExecution().executedPlan().toString());
        }
        LogicalPlan logicalPlan = sparkPlan.queryExecution().logical();
        QueryContext.current().getQueryPlan().setSparkPlan(logicalPlan.toString());
        log.info("SPARK LOGICAL PLAN {}", (Object)logicalPlan);
        if (QueryContext.current().isExplainSql()) {
            return new ExecuteResult((Iterable)Lists.newArrayList(), 0);
        }
        if (KapConfig.getInstanceFromEnv().isOnlyPlanInSparkEngine()) {
            return ResultPlan.completeResultForMdx(sparkPlan, relNode.getRowType());
        }
        return ResultPlan.getResult(sparkPlan, relNode.getRowType());
    }
}

