/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.QueryTrace;
import org.apache.kylin.engine.spark.utils.LogEx;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.query.util.SparkJobTrace$;
import org.apache.kylin.query.util.SparkJobTraceMetric;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.AppStatus;
import org.apache.spark.status.api.v1.JobData;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001\u0002\u0010 \u0001)B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"Aa\n\u0001B\u0001B\u0003%A\b\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!)\u0006A!A!\u0002\u00131\u0006\"B-\u0001\t\u0003Q\u0006b\u00022\u0001\u0005\u0004%\ta\u0019\u0005\u0007U\u0002\u0001\u000b\u0011\u00023\t\u000b-\u0004A\u0011\u00017\t\u000bA\u0004A\u0011A9\t\u000bQ\u0004A\u0011\u00017\t\u000bU\u0004A\u0011\u00017\b\u000bY|\u0002\u0012A<\u0007\u000byy\u0002\u0012\u0001=\t\u000besA\u0011A=\t\u000fit!\u0019!C\u0001w\"1qP\u0004Q\u0001\nqD\u0011\"!\u0001\u000f\u0005\u0004%\t!a\u0001\t\u0011\u0005-a\u0002)A\u0005\u0003\u000bA\u0011\"!\u0004\u000f\u0005\u0004%\t!a\u0001\t\u0011\u0005=a\u0002)A\u0005\u0003\u000bA\u0011\"!\u0005\u000f\u0005\u0004%\t!a\u0005\t\u000f\u0005Ua\u0002)A\u0005-\"I\u0011q\u0003\bC\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003[q\u0001\u0015!\u0003\u0002\u001c!I\u0011q\u0006\bC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\t\u0003\u001fr\u0001\u0015!\u0003\u00024!9\u0011\u0011\u000b\b\u0005\u0002\u0005M\u0003\"CA,\u001dE\u0005I\u0011AA-\u00055\u0019\u0006/\u0019:l\u0015>\u0014GK]1dK*\u0011\u0001%I\u0001\u0005kRLGN\u0003\u0002#G\u0005)\u0011/^3ss*\u0011A%J\u0001\u0006Wfd\u0017N\u001c\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Y\u0013\u0007\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004B]f\u0014VM\u001a\t\u0003eej\u0011a\r\u0006\u0003iU\nQ!\u001e;jYNT!AN\u001c\u0002\u000bM\u0004\u0018M]6\u000b\u0005a\u001a\u0013AB3oO&tW-\u0003\u0002;g\t)Aj\\4Fq\u0006A!n\u001c2He>,\b\u000f\u0005\u0002>\t:\u0011aH\u0011\t\u0003\u007f5j\u0011\u0001\u0011\u0006\u0003\u0003&\na\u0001\u0010:p_Rt\u0014BA\".\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\rk\u0013AC9vKJLHK]1dKB\u0011\u0011\nT\u0007\u0002\u0015*\u00111jI\u0001\u0007G>lWn\u001c8\n\u00055S%AC)vKJLHK]1dK\u00069\u0011/^3ss&#\u0017\u0001D:qCJ\\7i\u001c8uKb$\bCA)T\u001b\u0005\u0011&B\u0001\u001c&\u0013\t!&K\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0004ti\u0006\u0014H/\u0011;\u0011\u00051:\u0016B\u0001-.\u0005\u0011auN\\4\u0002\rqJg.\u001b;?)\u0019YVLX0aCB\u0011A\fA\u0007\u0002?!)1H\u0002a\u0001y!)qI\u0002a\u0001\u0011\")aJ\u0002a\u0001y!)qJ\u0002a\u0001!\"9QK\u0002I\u0001\u0002\u00041\u0016!C1qaN#\u0018\r^;t+\u0005!\u0007CA3i\u001b\u00051'BA4S\u0003\u001diW\r\u001e:jGNL!!\u001b4\u0003\u0013\u0005\u0003\bo\u0015;biV\u001c\u0018AC1qaN#\u0018\r^;tA\u0005Y!n\u001c2GS:L7\u000f[3e)\u0005i\u0007C\u0001\u0017o\u0013\tyWF\u0001\u0003V]&$\u0018!H2bY\u000e,H.\u0019;f\u0003:$Wi\u001d;j[\u0006$X\rR;sCRLwN\\:\u0015\u00055\u0014\b\"B:\u000b\u0001\u00041\u0016\u0001E2veJ,g\u000e\u001e+j[\u0016\u001cH/Y7q\u0003=\u0011Xm];mi\u000e{gN^3si\u0016$\u0017!G3oI\u0006\u0013gn\u001c:nC2,\u00050Z2vi&|g\u000e\u0016:bG\u0016\fQb\u00159be.TuN\u0019+sC\u000e,\u0007C\u0001/\u000f'\tq1\u0006F\u0001x\u0003%Y\u0017\r]\"p]\u001aLw-F\u0001}!\tIU0\u0003\u0002\u007f\u0015\nI1*\u00199D_:4\u0017nZ\u0001\u000bW\u0006\u00048i\u001c8gS\u001e\u0004\u0013\u0001G:qCJ\\'j\u001c2Ue\u0006\u001cW\rU1sC2dW\r\\'bqV\u0011\u0011Q\u0001\t\u0004Y\u0005\u001d\u0011bAA\u0005[\t\u0019\u0011J\u001c;\u00023M\u0004\u0018M]6K_\n$&/Y2f!\u0006\u0014\u0018\r\u001c7fY6\u000b\u0007\u0010I\u0001\u0016gB\f'o\u001b&pER\u0013\u0018mY3DC\u000eDW-T1y\u0003Y\u0019\b/\u0019:l\u0015>\u0014GK]1dK\u000e\u000b7\r[3NCb\u0004\u0013AF:qCJ\\'j\u001c2Ue\u0006\u001cW\rV5nK>,H/T:\u0016\u0003Y\u000bqc\u001d9be.TuN\u0019+sC\u000e,G+[7f_V$Xj\u001d\u0011\u0002%)|'\r\u0016:bG\u0016$\u0006N]3bIB{w\u000e\\\u000b\u0003\u00037\u0001B!!\b\u0002*5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0006d_:\u001cWO\u001d:f]RT1\u0001IA\u0013\u0015\t\t9#\u0001\u0003kCZ\f\u0017\u0002BA\u0016\u0003?\u0011!\u0003\u00165sK\u0006$\u0007k\\8m\u000bb,7-\u001e;pe\u0006\u0019\"n\u001c2Ue\u0006\u001cW\r\u00165sK\u0006$\u0007k\\8mA\u0005\u00112\u000f]1sW*{'\r\u0016:bG\u0016\u001c\u0015m\u00195f+\t\t\u0019\u0004E\u0004\u00026\u0005\u0015C(!\u0013\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\tQaY1dQ\u0016T1aSA\u001f\u0015\u0011\ty$!\u0011\u0002\rMD\u0017\rZ3e\u0015\r\t\u0019eI\u0001\bOV\fg/Y\u001a1\u0013\u0011\t9%a\u000e\u0003\u000b\r\u000b7\r[3\u0011\u0007q\u000bY%C\u0002\u0002N}\u00111c\u00159be.TuN\u0019+sC\u000e,W*\u001a;sS\u000e\f1c\u001d9be.TuN\u0019+sC\u000e,7)Y2iK\u0002\nacZ3u'B\f'o\u001b&pER\u0013\u0018mY3NKR\u0014\u0018n\u0019\u000b\u0005\u0003\u0013\n)\u0006C\u0003O9\u0001\u0007A(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u00037R3AVA/W\t\ty\u0006\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\u0013Ut7\r[3dW\u0016$'bAA5[\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00141\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class SparkJobTrace
implements LogEx {
    private final String jobGroup;
    private final QueryTrace queryTrace;
    private final String queryId;
    private final long startAt;
    private final AppStatus appStatus;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long $lessinit$greater$default$5() {
        return SparkJobTrace$.MODULE$.$lessinit$greater$default$5();
    }

    public static SparkJobTraceMetric getSparkJobTraceMetric(String string) {
        return SparkJobTrace$.MODULE$.getSparkJobTraceMetric(string);
    }

    public static Cache<String, SparkJobTraceMetric> sparkJobTraceCache() {
        return SparkJobTrace$.MODULE$.sparkJobTraceCache();
    }

    public static ThreadPoolExecutor jobTraceThreadPool() {
        return SparkJobTrace$.MODULE$.jobTraceThreadPool();
    }

    public static long sparkJobTraceTimeoutMs() {
        return SparkJobTrace$.MODULE$.sparkJobTraceTimeoutMs();
    }

    public static int sparkJobTraceCacheMax() {
        return SparkJobTrace$.MODULE$.sparkJobTraceCacheMax();
    }

    public static int sparkJobTraceParallelMax() {
        return SparkJobTrace$.MODULE$.sparkJobTraceParallelMax();
    }

    public static KapConfig kapConfig() {
        return SparkJobTrace$.MODULE$.kapConfig();
    }

    public <U> U logTime(String action, boolean debug, Function0<U> body) {
        return (U)LogEx.logTime$((LogEx)this, (String)action, (boolean)debug, body);
    }

    public <U> boolean logTime$default$2() {
        return LogEx.logTime$default$2$((LogEx)this);
    }

    public void logInfoIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logInfoIf$((LogEx)this, filter, msg);
    }

    public void logWarningIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logWarningIf$((LogEx)this, filter, msg);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public AppStatus appStatus() {
        return this.appStatus;
    }

    public void jobFinished() {
        try {
            long currentTimestamp = System.currentTimeMillis();
            SparkJobTrace$.MODULE$.jobTraceThreadPool().submit(new Runnable(this, currentTimestamp){
                private final /* synthetic */ SparkJobTrace $outer;
                private final long currentTimestamp$1;

                public void run() {
                    this.$outer.calculateAndEstimateDurations(this.currentTimestamp$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.currentTimestamp$1 = currentTimestamp$1;
                }
            });
        }
        catch (Throwable e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Having exception lost spark job trace task queryId: ").append($this.queryId).append(" kylin.query.spark-job-trace-parallel-max").append(SparkJobTrace$.MODULE$.sparkJobTraceCacheMax()).toString(), e);
        }
    }

    public void calculateAndEstimateDurations(long currentTimestamp) {
        try {
            Seq<JobData> jobDataSeq = this.appStatus().getJobData(this.jobGroup);
            if (jobDataSeq.isEmpty()) {
                return;
            }
            long jobExecutionTime = currentTimestamp - this.startAt;
            Option submissionTime = (Option)((TraversableOnce)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.submissionTime(), Seq$.MODULE$.canBuildFrom())).min(Ordering$.MODULE$.Option(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
            long prepareAndSubmitJobTime = 0L;
            if (submissionTime.isDefined()) {
                prepareAndSubmitJobTime = this.queryTrace.calculateDuration("PREPARE_AND_SUBMIT_JOB", ((Date)submissionTime.get()).getTime());
            }
            Option completionTime = (Option)((TraversableOnce)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.completionTime(), Seq$.MODULE$.canBuildFrom())).max(Ordering$.MODULE$.Option(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
            if (submissionTime.isDefined()) {
                jobExecutionTime = BoxesRunTime.unboxToLong((Object)completionTime.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> currentTimestamp)) - ((Date)submissionTime.get()).getTime();
            }
            Tuple2 jobMetrics = (Tuple2)((TraversableOnce)((TraversableLike)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.jobId()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> SparkJobTrace.$anonfun$calculateAndEstimateDurations$6(this, BoxesRunTime.unboxToInt((Object)x$5)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2.mcDD.sp(0.0, 0.0), (Function2 & Serializable & scala.Serializable)(acc, taskMetrics) -> new Tuple2.mcDD.sp(acc._1$mcD$sp() + BoxesRunTime.unboxToDouble((Object)taskMetrics.executorRunTime().head()) + BoxesRunTime.unboxToDouble((Object)taskMetrics.executorDeserializeTime().head()), acc._2$mcD$sp() + BoxesRunTime.unboxToDouble((Object)taskMetrics.gettingResultTime().head())));
            double launchDelayTimeSum = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)jobDataSeq.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.stageIds(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(this.appStatus().getStage(BoxesRunTime.unboxToInt((Object)stageId))), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)stage -> BoxesRunTime.boxToDouble((double)SparkJobTrace.$anonfun$calculateAndEstimateDurations$10(this, stage)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)v -> !Double.isNaN(v))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double sum = jobMetrics._1$mcD$sp() + jobMetrics._2$mcD$sp() + launchDelayTimeSum;
            double computingTime = jobMetrics._1$mcD$sp() * (double)jobExecutionTime / sum;
            double getResultTime = jobMetrics._2$mcD$sp() * (double)jobExecutionTime / sum;
            double launchDelayTime = launchDelayTimeSum * (double)jobExecutionTime / sum;
            SparkJobTrace$.MODULE$.sparkJobTraceCache().put((Object)this.queryId, (Object)new SparkJobTraceMetric(prepareAndSubmitJobTime, (long)launchDelayTime, (long)computingTime, (long)getResultTime));
        }
        catch (Throwable e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Failed trace spark job execution for ").append($this.jobGroup).toString(), e);
        }
    }

    public void resultConverted() {
        this.queryTrace.amendLast("FETCH_RESULT", System.currentTimeMillis());
    }

    public void endAbnormalExecutionTrace() {
        this.queryTrace.appendSpan("WAIT_FOR_EXECUTION", 0L);
        this.queryTrace.appendSpan("EXECUTION", System.currentTimeMillis() - this.startAt);
        this.queryTrace.appendSpan("FETCH_RESULT", 0L);
    }

    public static final /* synthetic */ Seq $anonfun$calculateAndEstimateDurations$6(SparkJobTrace $this, int x$5) {
        return $this.appStatus().getJobStagesSummary(x$5, 0.5);
    }

    public static final /* synthetic */ double $anonfun$calculateAndEstimateDurations$10(SparkJobTrace $this, SparkStageInfo stage) {
        return $this.appStatus().getTaskLaunchTime(stage.stageId(), 0.5) - (double)stage.submissionTime();
    }

    public SparkJobTrace(String jobGroup, QueryTrace queryTrace, String queryId, SparkContext sparkContext, long startAt) {
        this.jobGroup = jobGroup;
        this.queryTrace = queryTrace;
        this.queryId = queryId;
        this.startAt = startAt;
        Logging.$init$((Logging)this);
        LogEx.$init$((LogEx)this);
        this.appStatus = new AppStatus(sparkContext);
    }
}

