/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableWindowBridge;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapProjectRel;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.apache.kylin.query.util.RexUtils;

public class OlapWindowRel
extends Window
implements OlapRel {
    private ColumnRowType columnRowType;
    private OlapContext context;
    private Set<OlapContext> subContexts = Sets.newHashSet();
    private boolean existParentProjectNeedPushInfo;

    public OlapWindowRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
        super(cluster, traitSet, input, constants, rowType, groups);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getConvention() == input.getConvention() ? 1 : 0) != 0);
    }

    public Window copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new OlapWindowRel(this.getCluster(), traitSet, inputs.get(0), (List<RexLiteral>)this.constants, this.rowType, (List<Window.Group>)this.groups);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)this.displayCtxId(this.context)).itemIf("constants", (Object)this.constants, !this.constants.isEmpty()).itemIf("groups", (Object)this.groups, !this.groups.isEmpty());
    }

    @Override
    public void implementOlap(OlapRel.OlapImpl olapImpl) {
        olapImpl.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            this.context.setHasWindow(true);
            if (this == this.context.getTopNode() && !this.context.isHasAgg()) {
                this.amendContextColumns(olapImpl);
            }
        } else {
            ContextUtil.updateSubContexts(this.getGroupingColumns(), this.subContexts);
        }
    }

    private void amendContextColumns(OlapRel.OlapImpl olapImpl) {
        this.existParentProjectNeedPushInfo = this.checkParentProjectNeedPushInfo(olapImpl.getParentNodeStack());
        ContextUtil.amendAllColsIfNoAgg(this);
    }

    public boolean checkParentProjectNeedPushInfo(Deque<RelNode> allParents) {
        for (RelNode parent : allParents) {
            OlapProjectRel parentProject;
            if (!(parent instanceof OlapProjectRel) || !(parentProject = (OlapProjectRel)parent).isNeedPushInfoToSubCtx()) continue;
            return true;
        }
        return false;
    }

    public boolean isExistParentProjectNeedPushInfo() {
        return this.existParentProjectNeedPushInfo;
    }

    protected ColumnRowType buildColumnRowType() {
        OlapRel olapChild = (OlapRel)this.getInput(0);
        ColumnRowType inputColumnRowType = olapChild.getColumnRowType();
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        columns.addAll(inputColumnRowType.getAllColumns());
        for (Window.Group group : this.groups) {
            for (AggregateCall aggrCall : group.getAggregateCalls((Window)this)) {
                TblColRef aggrCallCol = TblColRef.newInnerColumn((String)aggrCall.getName(), (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
                columns.add(aggrCallCol);
            }
        }
        return new ColumnRowType(columns);
    }

    @Override
    public void implementRewrite(OlapRel.RewriteImpl rewriteImpl) {
        for (RelNode child : this.getInputs()) {
            rewriteImpl.visitChild(this, child);
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        for (EnumerableRel input : inputs) {
            if (!(input instanceof OlapRel)) continue;
            ((OlapRel)input).replaceTraitSet((RelTrait)EnumerableConvention.INSTANCE);
        }
        return EnumerableWindowBridge.createEnumerableWindow((RelOptCluster)this.getCluster(), (RelTraitSet)this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (RelNode)((RelNode)inputs.get(0)), (List)this.constants, (RelDataType)this.rowType, (List)this.groups);
    }

    @Override
    public boolean hasSubQuery() {
        for (RelNode child : this.getInputs()) {
            if (!((OlapRel)child).hasSubQuery()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    @Override
    public void implementContext(OlapRel.ContextImpl contextImpl, OlapRel.ContextVisitorState state) {
        contextImpl.fixSharedOlapTableScan((SingleRel)this);
        OlapRel.ContextVisitorState tempState = OlapRel.ContextVisitorState.init();
        contextImpl.visitChild(this.getInput(), this, tempState);
        if (tempState.hasFreeTable()) {
            contextImpl.allocateContext(this, this);
            tempState.setHasFreeTable(false);
        }
        state.merge(tempState);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public void implementCutContext(ICutContextStrategy.ContextCutImpl contextCutImpl) {
        this.context = null;
        contextCutImpl.visitChild(this.getInput());
    }

    @Override
    public void setContext(OlapContext context) {
        this.context = context;
        ((OlapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OlapContext context) {
        return true;
    }

    public Collection<TblColRef> getGroupingColumns() {
        ColumnRowType inputColumnRowType = ((OlapRel)this.getInput()).getColumnRowType();
        HashSet<TblColRef> tblColRefs = new HashSet<TblColRef>();
        for (Window.Group group : this.groups) {
            group.keys.forEach(grpKey -> tblColRefs.addAll(inputColumnRowType.getSourceColumnsByIndex((int)grpKey)));
            group.orderKeys.getFieldCollations().forEach(f -> tblColRefs.addAll(inputColumnRowType.getSourceColumnsByIndex(f.getFieldIndex())));
            group.aggCalls.stream().flatMap(call -> RexUtils.getAllInputRefs((RexNode)call).stream()).filter(inRef -> inRef.getIndex() < inputColumnRowType.size()).flatMap(inRef -> inputColumnRowType.getSourceColumnsByIndex(inRef.getIndex()).stream()).forEach(tblColRefs::add);
        }
        return tblColRefs;
    }

    @Override
    @Generated
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    @Generated
    public OlapContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public Set<OlapContext> getSubContexts() {
        return this.subContexts;
    }

    @Override
    @Generated
    public void setSubContexts(Set<OlapContext> subContexts) {
        this.subContexts = subContexts;
    }
}

