/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.transaction;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.event.Event;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.transaction.MessageSynchronization;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuditLogReplayWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAuditLogReplayWorker.class);
    protected static final long STEP = 1000L;
    protected final AuditLogStore auditLogStore;
    protected final KylinConfig config;
    protected volatile ScheduledExecutorService consumeExecutor;
    protected static volatile ScheduledExecutorService publicExecutorPool = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("PublicReplayWorker"));
    protected final AtomicBoolean isStopped = new AtomicBoolean(false);
    protected final int replayWaitMaxRetryTimes;
    protected final long replayWaitMaxTimeoutMills;
    protected String modelUuid;

    protected AbstractAuditLogReplayWorker(KylinConfig config, AuditLogStore auditLogStore) {
        this.config = config;
        this.auditLogStore = auditLogStore;
        this.replayWaitMaxRetryTimes = config.getReplayWaitMaxRetryTimes();
        this.replayWaitMaxTimeoutMills = config.getReplayWaitMaxTimeout();
    }

    public abstract void startSchedule(long var1, boolean var3);

    public void catchup() {
        if (this.isStopped.get()) {
            return;
        }
        this.consumeExecutor.submit(() -> this.catchupInternal(1));
    }

    public void catchupFrom(long expected) {
        this.updateOffset(expected);
        this.catchup();
    }

    public void close(boolean isGracefully) {
        this.isStopped.set(true);
        if (!this.consumeExecutor.equals(publicExecutorPool)) {
            if (isGracefully) {
                ExecutorServiceUtil.shutdownGracefully(this.consumeExecutor, 60);
            } else {
                ExecutorServiceUtil.forceShutdown(this.consumeExecutor);
            }
        }
    }

    protected void replayLogs(MessageSynchronization replayer, List<AuditLog> logs) {
        if (CollectionUtils.isEmpty(logs)) {
            return;
        }
        LinkedHashMap messagesMap = Maps.newLinkedHashMap();
        for (AuditLog log : logs) {
            if (this.modelUuid != null && !this.modelUuid.equals(log.getModelUuid())) continue;
            Event event = Event.fromLog(log);
            String unitId = log.getUnitId();
            if (messagesMap.get(unitId) == null) {
                UnitMessages newMessages = new UnitMessages();
                newMessages.getMessages().add(event);
                messagesMap.put(unitId, newMessages);
                continue;
            }
            ((UnitMessages)messagesMap.get(unitId)).getMessages().add(event);
        }
        try (SetLogCategory ignored = new SetLogCategory("metadata");){
            for (UnitMessages message : messagesMap.values()) {
                log.debug("replay {} event for project:{}", (Object)message.getMessages().size(), (Object)message.getKey());
                replayer.replay(message);
            }
        }
    }

    public abstract long getLogOffset();

    public abstract void updateOffset(long var1);

    protected abstract void catchupInternal(int var1);

    protected abstract boolean hasCatch(long var1);

    protected boolean logAllCommit(long startOffset, long endOffset) {
        return this.auditLogStore.count(startOffset, endOffset) == endOffset - startOffset;
    }

    protected void handleReloadAll(Exception e) {
        log.error("Critical exception happened, try to reload metadata ", (Throwable)e);
        try {
            MessageSynchronization messageSynchronization = MessageSynchronization.getInstance(KylinConfig.getInstanceFromEnv());
            messageSynchronization.replayAllMetadata(false);
        }
        catch (Throwable th) {
            log.error("reload all failed", th);
        }
        log.info("Reload finished");
    }

    protected void threadWait(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void waitForCatchup(long targetId, long timeout) throws TimeoutException {
        long endTime = System.currentTimeMillis() + timeout * 1000L;
        try {
            while (System.currentTimeMillis() < endTime) {
                if (this.hasCatch(targetId)) {
                    return;
                }
                Thread.sleep(50L);
            }
        }
        catch (Exception e) {
            log.info("Wait for catchup to {} failed", (Object)targetId, (Object)e);
            Thread.currentThread().interrupt();
        }
        throw new TimeoutException(String.format(Locale.ROOT, "Cannot reach %s before %s, current is %s", targetId, endTime, this.getLogOffset()));
    }

    public void reStartSchedule(long currentId) {
        if (!this.isStopped.get()) {
            log.info("replayer is running , don't need restart");
            return;
        }
        this.isStopped.set(false);
        this.consumeExecutor = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("ReplayWorker"));
        this.startSchedule(currentId, false);
    }

    @Generated
    public void setModelUuid(String modelUuid) {
        this.modelUuid = modelUuid;
    }

    protected static class SlideWindow
    extends FixedWindow {
        private final long upperLimit;

        public SlideWindow(FixedWindow batchWindow) {
            super(batchWindow.getStart(), batchWindow.getStart());
            this.upperLimit = batchWindow.getEnd();
            Preconditions.checkState((this.end <= this.upperLimit ? 1 : 0) != 0);
        }

        boolean canForwardRight() {
            return this.upperLimit > this.end;
        }

        boolean forwardRightStep(long step) {
            if (!this.canForwardRight()) {
                return false;
            }
            this.end = Math.min(this.end + step, this.upperLimit);
            return true;
        }

        void syncRightStep() {
            this.start = this.end;
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "(%s,%s,%s]", this.start, this.end, this.upperLimit);
        }
    }

    protected static class FixedWindow {
        protected long start;
        protected long end;

        public FixedWindow(long start, long end) {
            this.start = start;
            this.end = end;
            Preconditions.checkState((start <= end ? 1 : 0) != 0);
        }

        boolean isEmpty() {
            return this.length() == 0L;
        }

        long length() {
            return this.end - this.start;
        }

        public String toString() {
            return String.format(Locale.ROOT, "(%s,%s]", this.start, this.end);
        }

        @Generated
        public long getStart() {
            return this.start;
        }

        @Generated
        public long getEnd() {
            return this.end;
        }
    }

    protected static class DatabaseNotAvailableException
    extends KylinException {
        public DatabaseNotAvailableException(Exception e) {
            super((ErrorCodeSupplier)CommonErrorCode.FAILED_CONNECT_META_DATABASE, (Throwable)e);
        }
    }

    public static class EndReloadEvent {
    }

    public static class StartReloadEvent {
    }
}

