/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.lang.reflect.Field;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;

public final class ViewFileSystemUtils$ {
    public static ViewFileSystemUtils$ MODULE$;

    static {
        new ViewFileSystemUtils$();
    }

    public String convertViewfsToHdfs(String f, Configuration hadoopConfig) {
        String string;
        Path path = new Path(f);
        FileSystem fileSystem = FileSystem.get((URI)path.toUri(), (Configuration)hadoopConfig);
        if (fileSystem instanceof ViewFileSystem) {
            ViewFileSystem viewFileSystem = (ViewFileSystem)fileSystem;
            Field fsStateField = viewFileSystem.getClass().getDeclaredField("fsState");
            fsStateField.setAccessible(true);
            InodeTree fsState = (InodeTree)fsStateField.get(viewFileSystem);
            InodeTree.ResolveResult res = fsState.resolve(f, true);
            string = res.isInternalDir() ? f : Path.mergePaths((Path)new Path(((FileSystem)res.targetFileSystem).getUri()), (Path)res.remainingPath).toString();
        } else {
            string = fileSystem.resolvePath(path).toString();
        }
        return string;
    }

    public Seq<String> convertViewfsToHdfs(Seq<String> paths, Map<String, String> viewfsToHdfsCache, Configuration hadoopConfig) {
        return (Seq)paths.map((Function1 & java.io.Serializable & Serializable)path -> {
            String string;
            if (path.startsWith("viewfs")) {
                String[] pathSplit = path.split("/");
                int prefixIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathSplit)).size() - 1;
                String pathPrefix = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathSplit)).take(prefixIndex))).mkString("/");
                String hdfsPath = (String)viewfsToHdfsCache.getOrElseUpdate((Object)pathPrefix, (Function0 & java.io.Serializable & Serializable)() -> MODULE$.convertViewfsToHdfs(pathPrefix, hadoopConfig));
                string = new StringBuilder(1).append(hdfsPath).append("/").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathSplit)).drop(prefixIndex))).mkString("/")).toString();
            } else {
                string = path;
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ViewFileSystemUtils$() {
        MODULE$ = this;
    }
}

