/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.utils;

import org.apache.gluten.exception.GlutenException;
import org.apache.spark.SparkEnv;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.ClickHouseConfig;

public class SnowflakeIdWorker {
    private static volatile SnowflakeIdWorker INSTANCE;
    private final long twepoch = 1640966400L;
    private final long workerIdBits = 6L;
    private final long maxWorkerId = 63L;
    private final long sequenceBits = 16L;
    private final long workerIdShift = 16L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 65535L;
    private long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowflakeIdWorker(long workerId) {
        if (workerId > 63L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 63L));
        }
        this.workerId = workerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SnowflakeIdWorker getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SnowflakeIdWorker> clazz = SnowflakeIdWorker.class;
        synchronized (SnowflakeIdWorker.class) {
            if (INSTANCE != null) return INSTANCE;
            if (!SparkEnv.get().conf().contains(ClickHouseConfig.CLICKHOUSE_WORKER_ID())) {
                throw new IllegalArgumentException("Please set an unique value to " + ClickHouseConfig.CLICKHOUSE_WORKER_ID());
            }
            INSTANCE = new SnowflakeIdWorker(SparkEnv.get().conf().getLong(ClickHouseConfig.CLICKHOUSE_WORKER_ID(), 0L));
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new GlutenException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1640966400L << 22 | this.workerId << 16 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis() / 1000L;
    }
}

