/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.kylin.common.util.ByteUnit;
import org.apache.kylin.common.util.SizeConvertUtil;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class SizeConvertUtilTest {
    @Test
    public void testConvert() {
        long size = 15152114135L;
        String convertedSize = SizeConvertUtil.getReadableFileSize((long)size);
        Assert.assertEquals((Object)"14.1 GB", (Object)convertedSize);
    }

    @Test
    public void testGB() {
        Assert.assertEquals((long)1L, (long)SizeConvertUtil.byteStringAs((String)"1073741824b", (ByteUnit)ByteUnit.GiB));
        Assert.assertEquals((long)100L, (long)SizeConvertUtil.byteStringAs((String)"100GB", (ByteUnit)ByteUnit.GiB));
        Assert.assertEquals((long)102400L, (long)SizeConvertUtil.byteStringAs((String)"100GB", (ByteUnit)ByteUnit.MiB));
        Assert.assertEquals((long)0x6400000L, (long)SizeConvertUtil.byteStringAs((String)"100GB", (ByteUnit)ByteUnit.KiB));
        Assert.assertEquals((long)0x1900000000L, (long)SizeConvertUtil.byteStringAs((String)"100GB", (ByteUnit)ByteUnit.BYTE));
        Assert.assertEquals((long)0x6400000L, (long)SizeConvertUtil.byteStringAs((String)"100m", (ByteUnit)ByteUnit.BYTE));
        Assert.assertEquals((long)1L, (long)SizeConvertUtil.byteStringAsMb((String)"1024KB"));
    }

    @Test
    public void testByteCountToDisplaySize() {
        Assert.assertEquals((Object)"1 B", (Object)SizeConvertUtil.byteCountToDisplaySize((long)1L));
        Assert.assertEquals((Object)"1.00 KB", (Object)SizeConvertUtil.byteCountToDisplaySize((long)1024L));
        Assert.assertEquals((Object)"1.00 MB", (Object)SizeConvertUtil.byteCountToDisplaySize((long)0x100000L));
        Assert.assertEquals((Object)"1.00 GB", (Object)SizeConvertUtil.byteCountToDisplaySize((long)0x40000000L));
        Assert.assertEquals((Object)"1.00 TB", (Object)SizeConvertUtil.byteCountToDisplaySize((long)0x10000000000L));
        Assert.assertEquals((Object)"1024.00 TB", (Object)SizeConvertUtil.byteCountToDisplaySize((long)0x4000000000000L));
        Assert.assertEquals((Object)"2 B", (Object)SizeConvertUtil.byteCountToDisplaySize((long)2L));
        Assert.assertEquals((Object)"1.00 KB", (Object)SizeConvertUtil.byteCountToDisplaySize((long)1025L));
        Assert.assertEquals((Object)"1.00 KB", (Object)SizeConvertUtil.byteCountToDisplaySize((long)1025L, (int)2));
        Assert.assertEquals((Object)"1.01 KB", (Object)SizeConvertUtil.byteCountToDisplaySize((long)1035L));
        Assert.assertEquals((Object)"1.01 KB", (Object)SizeConvertUtil.byteCountToDisplaySize((long)1035L, (int)2));
    }
}

