/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.junit;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.junit.TimezoneExtension;
import org.apache.kylin.junit.annotation.MultiTimezoneTest;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.AnnotationUtils;

public class MultiTimezoneProvider
implements TestTemplateInvocationContextProvider {
    private static final String METHOD_CONTEXT_KEY = "context";

    public boolean supportsTestTemplate(ExtensionContext context) {
        if (!context.getTestMethod().isPresent()) {
            return false;
        }
        Method testMethod = (Method)context.getTestMethod().get();
        Optional annotations = AnnotationUtils.findAnnotation((Optional)context.getElement(), MultiTimezoneTest.class);
        if (!annotations.isPresent()) {
            return false;
        }
        MultiTimezoneContext methodContext = new MultiTimezoneContext(testMethod, ((MultiTimezoneTest)annotations.get()).timezones());
        this.getStore(context).put((Object)METHOD_CONTEXT_KEY, (Object)methodContext);
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        return ((MultiTimezoneContext)this.getStore(context).get((Object)METHOD_CONTEXT_KEY, MultiTimezoneContext.class)).getTimezones().stream().map(x -> new TimezoneInvocationContext((String)x));
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{MultiTimezoneProvider.class, context.getRequiredTestMethod()}));
    }

    static class TimezoneInvocationContext
    implements TestTemplateInvocationContext {
        private String timezone;

        public String getDisplayName(int invocationIndex) {
            return "[" + this.timezone + "]";
        }

        public List<Extension> getAdditionalExtensions() {
            return Collections.singletonList(new TimezoneExtension(this.timezone));
        }

        @Generated
        public TimezoneInvocationContext(String timezone) {
            this.timezone = timezone;
        }
    }

    static class MultiTimezoneContext {
        private Method testMethod;
        private List<String> timezones;

        public MultiTimezoneContext(Method testMethod, String[] timezones) {
            this.testMethod = testMethod;
            this.timezones = Lists.newArrayList((Object[])timezones);
        }

        @Generated
        public Method getTestMethod() {
            return this.testMethod;
        }

        @Generated
        public List<String> getTimezones() {
            return this.timezones;
        }

        @Generated
        public void setTestMethod(Method testMethod) {
            this.testMethod = testMethod;
        }

        @Generated
        public void setTimezones(List<String> timezones) {
            this.timezones = timezones;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiTimezoneContext)) {
                return false;
            }
            MultiTimezoneContext other = (MultiTimezoneContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Method this$testMethod = this.getTestMethod();
            Method other$testMethod = other.getTestMethod();
            if (this$testMethod == null ? other$testMethod != null : !((Object)this$testMethod).equals(other$testMethod)) {
                return false;
            }
            List<String> this$timezones = this.getTimezones();
            List<String> other$timezones = other.getTimezones();
            return !(this$timezones == null ? other$timezones != null : !((Object)this$timezones).equals(other$timezones));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MultiTimezoneContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Method $testMethod = this.getTestMethod();
            result = result * 59 + ($testMethod == null ? 43 : ((Object)$testMethod).hashCode());
            List<String> $timezones = this.getTimezones();
            result = result * 59 + ($timezones == null ? 43 : ((Object)$timezones).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MultiTimezoneProvider.MultiTimezoneContext(testMethod=" + this.getTestMethod() + ", timezones=" + this.getTimezones() + ")";
        }
    }
}

